/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-06-12 10:50:11 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=717 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=8778 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1344 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=27925 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10592 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1128 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_sliders7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_slides7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=116 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19378 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=428 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("642", "woocommerce_cleanup_draft_orders", "complete", "2025-05-13 01:28:55", "2025-05-13 01:28:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747099735;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747099735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-13 01:31:56", "2025-05-13 01:31:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("643", "woocommerce_cleanup_draft_orders", "complete", "2025-05-14 01:31:56", "2025-05-14 01:31:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747186316;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747186316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-14 04:43:05", "2025-05-14 04:43:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("644", "fetch_patterns", "complete", "2025-05-13 19:03:52", "2025-05-13 19:03:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163032;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163032;}", "7", "1", "2025-05-13 19:03:57", "2025-05-13 19:03:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("645", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-05-13 19:03:58", "2025-05-13 19:03:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163038;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163038;}", "2", "1", "2025-05-13 19:04:03", "2025-05-13 19:04:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("646", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:09", "2025-05-13 19:04:09", "{\"update_callback\":\"wc_update_670_purge_comments_count_cache\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163049;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163049;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("647", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:10", "2025-05-13 19:04:10", "{\"update_callback\":\"wc_update_670_delete_deprecated_remote_inbox_notifications_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163050;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163050;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("648", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:11", "2025-05-13 19:04:11", "{\"update_callback\":\"wc_update_700_remove_download_log_fk\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163051;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163051;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("649", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:12", "2025-05-13 19:04:12", "{\"update_callback\":\"wc_update_700_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163052;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163052;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("650", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:13", "2025-05-13 19:04:13", "{\"update_callback\":\"wc_update_721_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163053;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163053;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("651", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:14", "2025-05-13 19:04:14", "{\"update_callback\":\"wc_update_721_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163054;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163054;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("652", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:15", "2025-05-13 19:04:15", "{\"update_callback\":\"wc_update_722_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163055;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163055;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("653", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:16", "2025-05-13 19:04:16", "{\"update_callback\":\"wc_update_722_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163056;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("654", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:17", "2025-05-13 19:04:17", "{\"update_callback\":\"wc_update_750_add_columns_to_order_stats_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163057;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163057;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("655", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:18", "2025-05-13 19:04:18", "{\"update_callback\":\"wc_update_750_disable_new_product_management_experience\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163058;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163058;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("656", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:19", "2025-05-13 19:04:19", "{\"update_callback\":\"wc_update_770_remove_multichannel_marketing_feature_options\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163059;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163059;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("657", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:20", "2025-05-13 19:04:20", "{\"update_callback\":\"wc_update_810_migrate_transactional_metadata_for_hpos\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163060;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163060;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("658", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:21", "2025-05-13 19:04:21", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163061;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163061;}", "2", "1", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("659", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:22", "2025-05-13 19:04:22", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163062;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163062;}", "2", "1", "2025-05-13 19:04:27", "2025-05-13 19:04:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("660", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:23", "2025-05-13 19:04:23", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163063;}", "2", "1", "2025-05-13 19:04:27", "2025-05-13 19:04:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("661", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:24", "2025-05-13 19:04:24", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163064;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163064;}", "2", "1", "2025-05-13 19:04:27", "2025-05-13 19:04:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("662", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:25", "2025-05-13 19:04:25", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163065;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163065;}", "2", "1", "2025-05-13 19:04:27", "2025-05-13 19:04:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("663", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:26", "2025-05-13 19:04:26", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163066;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163066;}", "2", "1", "2025-05-13 19:04:27", "2025-05-13 19:04:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("664", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:27", "2025-05-13 19:04:27", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163067;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163067;}", "2", "1", "2025-05-13 19:04:27", "2025-05-13 19:04:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("665", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:28", "2025-05-13 19:04:28", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163068;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163068;}", "2", "1", "2025-05-13 19:04:58", "2025-05-13 19:04:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("666", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:29", "2025-05-13 19:04:29", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163069;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163069;}", "2", "1", "2025-05-13 19:04:58", "2025-05-13 19:04:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("667", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:30", "2025-05-13 19:04:30", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163070;}", "2", "1", "2025-05-13 19:04:58", "2025-05-13 19:04:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("668", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:31", "2025-05-13 19:04:31", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163071;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163071;}", "2", "1", "2025-05-13 19:04:58", "2025-05-13 19:04:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("669", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:32", "2025-05-13 19:04:32", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163072;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163072;}", "2", "1", "2025-05-13 19:04:58", "2025-05-13 19:04:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("670", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:33", "2025-05-13 19:04:33", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163073;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163073;}", "2", "1", "2025-05-13 19:04:58", "2025-05-13 19:04:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("671", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:34", "2025-05-13 19:04:34", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163074;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163074;}", "2", "1", "2025-05-13 19:04:58", "2025-05-13 19:04:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("672", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:35", "2025-05-13 19:04:35", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163075;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163075;}", "2", "1", "2025-05-13 19:04:58", "2025-05-13 19:04:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("673", "woocommerce_run_update_callback", "complete", "2025-05-13 19:04:36", "2025-05-13 19:04:36", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163076;}", "2", "1", "2025-05-13 19:04:58", "2025-05-13 19:04:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("674", "woocommerce_update_db_to_current_version", "complete", "2025-05-13 19:04:37", "2025-05-13 19:04:37", "{\"version\":\"9.8.5\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747163077;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747163077;}", "2", "1", "2025-05-13 19:04:58", "2025-05-13 19:04:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("675", "action_scheduler/migration_hook", "complete", "2025-05-13 19:21:04", "2025-05-13 19:21:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747164064;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747164064;}", "1", "1", "2025-05-13 19:22:07", "2025-05-13 19:22:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("676", "action_scheduler/migration_hook", "failed", "2025-05-13 19:23:07", "2025-05-13 19:23:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747164187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747164187;}", "1", "1", "2025-05-13 19:24:08", "2025-05-13 19:24:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("677", "woocommerce_cleanup_draft_orders", "complete", "2025-05-15 04:43:05", "2025-05-15 04:43:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747284185;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747284185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-15 06:41:36", "2025-05-15 06:41:36", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("678", "woocommerce_cleanup_draft_orders", "complete", "2025-05-16 06:41:36", "2025-05-16 06:41:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747377696;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747377696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-16 08:12:30", "2025-05-16 08:12:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("679", "woocommerce_cleanup_draft_orders", "complete", "2025-05-17 08:12:30", "2025-05-17 08:12:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747469550;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747469550;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-17 08:21:11", "2025-05-17 08:21:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("680", "woocommerce_cleanup_draft_orders", "complete", "2025-05-18 08:21:11", "2025-05-18 08:21:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747556471;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747556471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-18 08:30:08", "2025-05-18 08:30:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("681", "woocommerce_cleanup_draft_orders", "complete", "2025-05-19 08:30:08", "2025-05-19 08:30:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747643408;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747643408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-19 09:04:55", "2025-05-19 09:04:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("682", "woocommerce_cleanup_draft_orders", "complete", "2025-05-20 09:04:55", "2025-05-20 09:04:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747731895;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747731895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-20 09:59:34", "2025-05-20 09:59:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("683", "woocommerce_cleanup_draft_orders", "complete", "2025-05-21 09:59:34", "2025-05-21 09:59:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747821574;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747821574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-21 10:16:17", "2025-05-21 10:16:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("684", "woocommerce_cleanup_draft_orders", "complete", "2025-05-22 10:16:17", "2025-05-22 10:16:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747908977;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747908977;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-22 13:12:05", "2025-05-22 13:12:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("685", "woocommerce_cleanup_draft_orders", "complete", "2025-05-23 13:12:05", "2025-05-23 13:12:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748005925;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748005925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-23 13:20:39", "2025-05-23 13:20:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("686", "woocommerce_cleanup_draft_orders", "complete", "2025-05-24 13:20:39", "2025-05-24 13:20:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748092839;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748092839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-24 15:03:32", "2025-05-24 15:03:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("687", "woocommerce_cleanup_draft_orders", "complete", "2025-05-25 15:03:32", "2025-05-25 15:03:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748185412;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748185412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-25 15:44:17", "2025-05-25 15:44:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("688", "woocommerce_cleanup_draft_orders", "complete", "2025-05-26 15:44:17", "2025-05-26 15:44:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748274257;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748274257;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-26 17:00:41", "2025-05-26 17:00:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("689", "woocommerce_cleanup_draft_orders", "complete", "2025-05-27 17:00:41", "2025-05-27 17:00:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748365241;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748365241;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-27 17:53:28", "2025-05-27 17:53:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("690", "woocommerce_cleanup_draft_orders", "complete", "2025-05-28 17:53:28", "2025-05-28 17:53:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748454808;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748454808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-28 18:03:46", "2025-05-28 18:03:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("691", "woocommerce_cleanup_draft_orders", "complete", "2025-05-29 18:03:46", "2025-05-29 18:03:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748541826;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748541826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-29 19:10:53", "2025-05-29 19:10:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("692", "woocommerce_cleanup_draft_orders", "complete", "2025-05-30 19:10:53", "2025-05-30 19:10:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748632253;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748632253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-30 19:18:18", "2025-05-30 19:18:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("693", "woocommerce_cleanup_draft_orders", "complete", "2025-05-31 19:18:18", "2025-05-31 19:18:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748719098;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748719098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-05-31 20:05:56", "2025-05-31 20:05:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("694", "woocommerce_cleanup_draft_orders", "complete", "2025-06-01 20:05:56", "2025-06-01 20:05:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748808356;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748808356;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-06-01 20:12:17", "2025-06-01 20:12:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("695", "woocommerce_cleanup_draft_orders", "complete", "2025-06-02 20:12:17", "2025-06-02 20:12:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748895137;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748895137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-06-02 21:28:17", "2025-06-02 21:28:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("696", "woocommerce_cleanup_draft_orders", "complete", "2025-06-03 21:28:17", "2025-06-03 21:28:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748986097;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748986097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-06-03 22:30:45", "2025-06-03 22:30:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("697", "woocommerce_cleanup_draft_orders", "complete", "2025-06-04 22:30:45", "2025-06-04 22:30:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749076245;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749076245;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-06-05 05:03:33", "2025-06-05 05:03:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("698", "woocommerce_cleanup_draft_orders", "complete", "2025-06-06 05:03:33", "2025-06-06 05:03:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749186213;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749186213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-06-06 12:45:23", "2025-06-06 12:45:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("699", "woocommerce_cleanup_draft_orders", "complete", "2025-06-07 12:45:23", "2025-06-07 12:45:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749300323;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749300323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-06-07 13:11:58", "2025-06-07 13:11:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("700", "woocommerce_cleanup_draft_orders", "complete", "2025-06-08 13:11:58", "2025-06-08 13:11:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749388318;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749388318;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-06-08 16:52:38", "2025-06-08 16:52:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("701", "woocommerce_cleanup_draft_orders", "complete", "2025-06-09 16:52:38", "2025-06-09 16:52:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749487958;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749487958;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-06-09 17:31:09", "2025-06-09 17:31:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("702", "woocommerce_cleanup_draft_orders", "complete", "2025-06-10 17:31:09", "2025-06-10 17:31:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749576669;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749576669;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-06-10 17:52:54", "2025-06-10 17:52:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("703", "woocommerce_cleanup_draft_orders", "complete", "2025-06-11 17:52:54", "2025-06-11 17:52:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749664374;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749664374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-06-11 18:44:09", "2025-06-11 18:44:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("704", "woocommerce_cleanup_draft_orders", "pending", "2025-06-12 18:44:09", "2025-06-12 18:44:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749753849;s:18:\"\0*\0first_timestamp\";i:1657351447;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749753849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("705", "fetch_patterns", "complete", "2025-06-12 09:42:09", "2025-06-12 09:42:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749721329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749721329;}", "7", "1", "2025-06-12 09:42:33", "2025-06-12 09:42:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("706", "woocommerce_run_update_callback", "complete", "2025-06-12 09:42:32", "2025-06-12 09:42:32", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749721352;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749721352;}", "2", "1", "2025-06-12 09:42:33", "2025-06-12 09:42:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("707", "woocommerce_run_update_callback", "complete", "2025-06-12 09:42:33", "2025-06-12 09:42:33", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749721353;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749721353;}", "2", "1", "2025-06-12 09:42:33", "2025-06-12 09:42:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("708", "woocommerce_update_db_to_current_version", "complete", "2025-06-12 09:42:34", "2025-06-12 09:42:34", "{\"version\":\"9.9.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749721354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749721354;}", "2", "1", "2025-06-12 09:43:38", "2025-06-12 09:43:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("709", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-06-12 09:42:33", "2025-06-12 09:42:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749721353;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749721353;}", "2", "1", "2025-06-12 09:42:33", "2025-06-12 09:42:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("710", "woocommerce_refresh_order_count_cache", "pending", "2025-06-12 21:42:33", "2025-06-12 21:42:33", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749764553;s:18:\"\0*\0first_timestamp\";i:1749764553;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749764553;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("711", "action_scheduler/migration_hook", "complete", "2025-06-12 10:05:52", "2025-06-12 10:05:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749722752;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749722752;}", "1", "1", "2025-06-12 10:06:30", "2025-06-12 10:06:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("712", "action_scheduler/migration_hook", "failed", "2025-06-12 10:07:30", "2025-06-12 10:07:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749722850;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749722850;}", "1", "1", "2025-06-12 10:07:34", "2025-06-12 10:07:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("713", "wc_delete_related_product_transients_async", "complete", "2025-06-12 10:12:07", "2025-06-12 10:12:07", "{\"post_id\":744}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749723127;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749723127;}", "9", "1", "2025-06-12 10:12:23", "2025-06-12 10:12:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("714", "wc_delete_related_product_transients_async", "complete", "2025-06-12 10:12:23", "2025-06-12 10:12:23", "{\"post_id\":816}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749723143;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749723143;}", "9", "1", "2025-06-12 10:12:23", "2025-06-12 10:12:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("715", "wc_delete_related_product_transients_async", "complete", "2025-06-12 10:12:30", "2025-06-12 10:12:30", "{\"post_id\":744}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749723150;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749723150;}", "9", "1", "2025-06-12 10:12:37", "2025-06-12 10:12:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("716", "wc_delete_related_product_transients_async", "complete", "2025-06-12 10:12:36", "2025-06-12 10:12:36", "{\"post_id\":791}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749723156;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749723156;}", "9", "1", "2025-06-12 10:12:37", "2025-06-12 10:12:37", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc_update_product_lookup_tables");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "wc_delete_related_product_transients_group");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1123", "642", "ایجاد فعالیت", "2025-05-12 01:28:55", "2025-05-12 01:28:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1124", "642", "عملیات توسط WP Cron شروع شد", "2025-05-13 01:31:56", "2025-05-13 01:31:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1125", "642", "عملیات توسط WP Cron کامل شد", "2025-05-13 01:31:56", "2025-05-13 01:31:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1126", "643", "ایجاد فعالیت", "2025-05-13 01:31:56", "2025-05-13 01:31:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1127", "644", "ایجاد فعالیت", "2025-05-13 19:03:52", "2025-05-13 19:03:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1128", "645", "ایجاد فعالیت", "2025-05-13 19:03:57", "2025-05-13 19:03:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1129", "644", "عملیات توسط Async Request شروع شد", "2025-05-13 19:03:57", "2025-05-13 19:03:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1130", "644", "عملیات توسط Async Request کامل شد", "2025-05-13 19:03:57", "2025-05-13 19:03:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1131", "645", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:03", "2025-05-13 19:04:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1132", "645", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:03", "2025-05-13 19:04:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1133", "646", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1134", "647", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1135", "648", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1136", "649", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1137", "650", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1138", "651", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1139", "652", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1140", "653", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1141", "654", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1142", "655", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1143", "656", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1144", "657", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1145", "658", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1146", "659", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1147", "660", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1148", "661", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1149", "662", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1150", "663", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1151", "664", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1152", "665", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1153", "666", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1154", "667", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1155", "668", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1156", "669", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1157", "670", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1158", "671", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1159", "672", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1160", "673", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1161", "674", "ایجاد فعالیت", "2025-05-13 19:04:09", "2025-05-13 19:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1162", "646", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1163", "646", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1164", "647", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1165", "647", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1166", "648", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1167", "648", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1168", "649", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1169", "649", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1170", "650", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1171", "650", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1172", "651", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1173", "651", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1174", "652", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1175", "652", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1176", "653", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1177", "653", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1178", "654", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1179", "654", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1180", "655", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1181", "655", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1182", "656", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1183", "656", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1184", "657", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1185", "657", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1186", "658", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1187", "658", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1188", "659", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1189", "659", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:26", "2025-05-13 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1190", "660", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:27", "2025-05-13 19:04:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1191", "660", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:27", "2025-05-13 19:04:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1192", "661", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:27", "2025-05-13 19:04:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1193", "661", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:27", "2025-05-13 19:04:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1194", "662", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:27", "2025-05-13 19:04:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1195", "662", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:27", "2025-05-13 19:04:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1196", "663", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:27", "2025-05-13 19:04:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1197", "663", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:27", "2025-05-13 19:04:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1198", "664", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:04:27", "2025-05-13 19:04:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1199", "664", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:04:27", "2025-05-13 19:04:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1200", "665", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1201", "665", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1202", "666", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1203", "666", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1204", "667", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1205", "667", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1206", "668", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1207", "668", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1208", "669", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1209", "669", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1210", "670", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1211", "670", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1212", "671", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1213", "671", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1214", "672", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1215", "672", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1216", "673", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1217", "673", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1218", "674", "عملیات توسط Async Request شروع شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1219", "674", "عملیات توسط Async Request کامل شد", "2025-05-13 19:04:58", "2025-05-13 19:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1220", "675", "ایجاد فعالیت", "2025-05-13 19:20:04", "2025-05-13 19:20:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1221", "675", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:22:07", "2025-05-13 19:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1222", "675", "عملیات توسط WP Cron کامل شد", "2025-05-13 19:22:07", "2025-05-13 19:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1223", "676", "ایجاد فعالیت", "2025-05-13 19:22:07", "2025-05-13 19:22:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1224", "676", "عملیات توسط WP Cron شروع شد", "2025-05-13 19:24:08", "2025-05-13 19:24:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1225", "676", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-05-13 19:24:08", "2025-05-13 19:24:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1226", "643", "عملیات توسط WP Cron شروع شد", "2025-05-14 04:43:05", "2025-05-14 04:43:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1227", "643", "عملیات توسط WP Cron کامل شد", "2025-05-14 04:43:05", "2025-05-14 04:43:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1228", "677", "ایجاد فعالیت", "2025-05-14 04:43:05", "2025-05-14 04:43:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1229", "677", "عملیات توسط WP Cron شروع شد", "2025-05-15 06:41:36", "2025-05-15 06:41:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1230", "677", "عملیات توسط WP Cron کامل شد", "2025-05-15 06:41:36", "2025-05-15 06:41:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1231", "678", "ایجاد فعالیت", "2025-05-15 06:41:36", "2025-05-15 06:41:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1232", "678", "عملیات توسط WP Cron شروع شد", "2025-05-16 08:12:30", "2025-05-16 08:12:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1233", "678", "عملیات توسط WP Cron کامل شد", "2025-05-16 08:12:30", "2025-05-16 08:12:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1234", "679", "ایجاد فعالیت", "2025-05-16 08:12:30", "2025-05-16 08:12:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1235", "679", "عملیات توسط WP Cron شروع شد", "2025-05-17 08:21:11", "2025-05-17 08:21:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1236", "679", "عملیات توسط WP Cron کامل شد", "2025-05-17 08:21:11", "2025-05-17 08:21:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1237", "680", "ایجاد فعالیت", "2025-05-17 08:21:11", "2025-05-17 08:21:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1238", "680", "عملیات توسط WP Cron شروع شد", "2025-05-18 08:30:08", "2025-05-18 08:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1239", "680", "عملیات توسط WP Cron کامل شد", "2025-05-18 08:30:08", "2025-05-18 08:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1240", "681", "ایجاد فعالیت", "2025-05-18 08:30:08", "2025-05-18 08:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1241", "681", "عملیات توسط WP Cron شروع شد", "2025-05-19 09:04:55", "2025-05-19 09:04:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1242", "681", "عملیات توسط WP Cron کامل شد", "2025-05-19 09:04:55", "2025-05-19 09:04:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1243", "682", "ایجاد فعالیت", "2025-05-19 09:04:55", "2025-05-19 09:04:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1244", "682", "عملیات توسط WP Cron شروع شد", "2025-05-20 09:59:34", "2025-05-20 09:59:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1245", "682", "عملیات توسط WP Cron کامل شد", "2025-05-20 09:59:34", "2025-05-20 09:59:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1246", "683", "ایجاد فعالیت", "2025-05-20 09:59:34", "2025-05-20 09:59:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1247", "683", "عملیات توسط WP Cron شروع شد", "2025-05-21 10:16:17", "2025-05-21 10:16:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1248", "683", "عملیات توسط WP Cron کامل شد", "2025-05-21 10:16:17", "2025-05-21 10:16:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1249", "684", "ایجاد فعالیت", "2025-05-21 10:16:17", "2025-05-21 10:16:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1250", "684", "عملیات توسط WP Cron شروع شد", "2025-05-22 13:12:05", "2025-05-22 13:12:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1251", "684", "عملیات توسط WP Cron کامل شد", "2025-05-22 13:12:05", "2025-05-22 13:12:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1252", "685", "ایجاد فعالیت", "2025-05-22 13:12:05", "2025-05-22 13:12:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("1253", "685", "عملیات توسط WP Cron شروع شد", "2025-05-23 13:20:39", "2025-05-23 13:20:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1254", "685", "عملیات توسط WP Cron کامل شد", "2025-05-23 13:20:39", "2025-05-23 13:20:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1255", "686", "ایجاد فعالیت", "2025-05-23 13:20:39", "2025-05-23 13:20:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1256", "686", "عملیات توسط WP Cron شروع شد", "2025-05-24 15:03:32", "2025-05-24 15:03:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1257", "686", "عملیات توسط WP Cron کامل شد", "2025-05-24 15:03:32", "2025-05-24 15:03:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1258", "687", "ایجاد فعالیت", "2025-05-24 15:03:32", "2025-05-24 15:03:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1259", "687", "عملیات توسط WP Cron شروع شد", "2025-05-25 15:44:17", "2025-05-25 15:44:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1260", "687", "عملیات توسط WP Cron کامل شد", "2025-05-25 15:44:17", "2025-05-25 15:44:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1261", "688", "ایجاد فعالیت", "2025-05-25 15:44:17", "2025-05-25 15:44:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1262", "688", "عملیات توسط WP Cron شروع شد", "2025-05-26 17:00:41", "2025-05-26 17:00:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1263", "688", "عملیات توسط WP Cron کامل شد", "2025-05-26 17:00:41", "2025-05-26 17:00:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1264", "689", "ایجاد فعالیت", "2025-05-26 17:00:41", "2025-05-26 17:00:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1265", "689", "عملیات توسط WP Cron شروع شد", "2025-05-27 17:53:28", "2025-05-27 17:53:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1266", "689", "عملیات توسط WP Cron کامل شد", "2025-05-27 17:53:28", "2025-05-27 17:53:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1267", "690", "ایجاد فعالیت", "2025-05-27 17:53:28", "2025-05-27 17:53:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1268", "690", "عملیات توسط WP Cron شروع شد", "2025-05-28 18:03:46", "2025-05-28 18:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1269", "690", "عملیات توسط WP Cron کامل شد", "2025-05-28 18:03:46", "2025-05-28 18:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1270", "691", "ایجاد فعالیت", "2025-05-28 18:03:46", "2025-05-28 18:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1271", "691", "عملیات توسط WP Cron شروع شد", "2025-05-29 19:10:53", "2025-05-29 19:10:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1272", "691", "عملیات توسط WP Cron کامل شد", "2025-05-29 19:10:53", "2025-05-29 19:10:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1273", "692", "ایجاد فعالیت", "2025-05-29 19:10:53", "2025-05-29 19:10:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1274", "692", "عملیات توسط WP Cron شروع شد", "2025-05-30 19:18:18", "2025-05-30 19:18:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1275", "692", "عملیات توسط WP Cron کامل شد", "2025-05-30 19:18:18", "2025-05-30 19:18:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1276", "693", "ایجاد فعالیت", "2025-05-30 19:18:18", "2025-05-30 19:18:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1277", "693", "عملیات توسط WP Cron شروع شد", "2025-05-31 20:05:56", "2025-05-31 20:05:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1278", "693", "عملیات توسط WP Cron کامل شد", "2025-05-31 20:05:56", "2025-05-31 20:05:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1279", "694", "ایجاد فعالیت", "2025-05-31 20:05:56", "2025-05-31 20:05:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1280", "694", "عملیات توسط WP Cron شروع شد", "2025-06-01 20:12:17", "2025-06-01 20:12:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1281", "694", "عملیات توسط WP Cron کامل شد", "2025-06-01 20:12:17", "2025-06-01 20:12:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1282", "695", "ایجاد فعالیت", "2025-06-01 20:12:17", "2025-06-01 20:12:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1283", "695", "عملیات توسط WP Cron شروع شد", "2025-06-02 21:28:17", "2025-06-02 21:28:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1284", "695", "عملیات توسط WP Cron کامل شد", "2025-06-02 21:28:17", "2025-06-02 21:28:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1285", "696", "ایجاد فعالیت", "2025-06-02 21:28:17", "2025-06-02 21:28:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1286", "696", "عملیات توسط WP Cron شروع شد", "2025-06-03 22:30:45", "2025-06-03 22:30:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1287", "696", "عملیات توسط WP Cron کامل شد", "2025-06-03 22:30:45", "2025-06-03 22:30:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1288", "697", "ایجاد فعالیت", "2025-06-03 22:30:45", "2025-06-03 22:30:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1289", "697", "عملیات توسط WP Cron شروع شد", "2025-06-05 05:03:33", "2025-06-05 05:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1290", "697", "عملیات توسط WP Cron کامل شد", "2025-06-05 05:03:33", "2025-06-05 05:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1291", "698", "ایجاد فعالیت", "2025-06-05 05:03:33", "2025-06-05 05:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1292", "698", "عملیات توسط WP Cron شروع شد", "2025-06-06 12:45:23", "2025-06-06 12:45:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1293", "698", "عملیات توسط WP Cron کامل شد", "2025-06-06 12:45:23", "2025-06-06 12:45:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1294", "699", "ایجاد فعالیت", "2025-06-06 12:45:23", "2025-06-06 12:45:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1295", "699", "عملیات توسط WP Cron شروع شد", "2025-06-07 13:11:58", "2025-06-07 13:11:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1296", "699", "عملیات توسط WP Cron کامل شد", "2025-06-07 13:11:58", "2025-06-07 13:11:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1297", "700", "ایجاد فعالیت", "2025-06-07 13:11:58", "2025-06-07 13:11:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1298", "700", "عملیات توسط WP Cron شروع شد", "2025-06-08 16:52:38", "2025-06-08 16:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1299", "700", "عملیات توسط WP Cron کامل شد", "2025-06-08 16:52:38", "2025-06-08 16:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1300", "701", "ایجاد فعالیت", "2025-06-08 16:52:38", "2025-06-08 16:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1301", "701", "عملیات توسط WP Cron شروع شد", "2025-06-09 17:31:09", "2025-06-09 17:31:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1302", "701", "عملیات توسط WP Cron کامل شد", "2025-06-09 17:31:09", "2025-06-09 17:31:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1303", "702", "ایجاد فعالیت", "2025-06-09 17:31:09", "2025-06-09 17:31:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1304", "702", "عملیات توسط WP Cron شروع شد", "2025-06-10 17:52:54", "2025-06-10 17:52:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1305", "702", "عملیات توسط WP Cron کامل شد", "2025-06-10 17:52:54", "2025-06-10 17:52:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1306", "703", "ایجاد فعالیت", "2025-06-10 17:52:54", "2025-06-10 17:52:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1307", "703", "عملیات توسط WP Cron شروع شد", "2025-06-11 18:44:09", "2025-06-11 18:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1308", "703", "عملیات توسط WP Cron کامل شد", "2025-06-11 18:44:09", "2025-06-11 18:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1309", "704", "ایجاد فعالیت", "2025-06-11 18:44:09", "2025-06-11 18:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1310", "705", "ایجاد فعالیت", "2025-06-12 09:42:09", "2025-06-12 09:42:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1311", "706", "ایجاد فعالیت", "2025-06-12 09:42:32", "2025-06-12 09:42:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1312", "707", "ایجاد فعالیت", "2025-06-12 09:42:32", "2025-06-12 09:42:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1313", "708", "ایجاد فعالیت", "2025-06-12 09:42:32", "2025-06-12 09:42:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1314", "709", "ایجاد فعالیت", "2025-06-12 09:42:32", "2025-06-12 09:42:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1315", "705", "عملیات توسط WP Cron شروع شد", "2025-06-12 09:42:33", "2025-06-12 09:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1316", "705", "عملیات توسط WP Cron کامل شد", "2025-06-12 09:42:33", "2025-06-12 09:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1317", "706", "عملیات توسط WP Cron شروع شد", "2025-06-12 09:42:33", "2025-06-12 09:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1318", "706", "عملیات توسط WP Cron کامل شد", "2025-06-12 09:42:33", "2025-06-12 09:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1319", "707", "عملیات توسط WP Cron شروع شد", "2025-06-12 09:42:33", "2025-06-12 09:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1320", "707", "عملیات توسط WP Cron کامل شد", "2025-06-12 09:42:33", "2025-06-12 09:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1321", "709", "عملیات توسط WP Cron شروع شد", "2025-06-12 09:42:33", "2025-06-12 09:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1322", "710", "ایجاد فعالیت", "2025-06-12 09:42:33", "2025-06-12 09:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1323", "709", "عملیات توسط WP Cron کامل شد", "2025-06-12 09:42:33", "2025-06-12 09:42:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("1324", "708", "عملیات توسط Async Request شروع شد", "2025-06-12 09:43:38", "2025-06-12 09:43:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1325", "708", "عملیات توسط Async Request کامل شد", "2025-06-12 09:43:38", "2025-06-12 09:43:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1326", "711", "ایجاد فعالیت", "2025-06-12 10:04:52", "2025-06-12 10:04:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1327", "711", "عملیات توسط WP Cron شروع شد", "2025-06-12 10:06:30", "2025-06-12 10:06:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1328", "711", "عملیات توسط WP Cron کامل شد", "2025-06-12 10:06:30", "2025-06-12 10:06:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1329", "712", "ایجاد فعالیت", "2025-06-12 10:06:30", "2025-06-12 10:06:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1330", "712", "عملیات توسط Async Request شروع شد", "2025-06-12 10:07:34", "2025-06-12 10:07:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1331", "712", "اقدام از طریق Async Request انجام نشد: اقدام زمان‌بندی‌شده برای action_scheduler/migration_hook اجرا نخواهد شد زیرا هیچ فراخوانی برگشتی ثبت نشده است.", "2025-06-12 10:07:34", "2025-06-12 10:07:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1332", "713", "ایجاد فعالیت", "2025-06-12 10:12:07", "2025-06-12 10:12:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1333", "714", "ایجاد فعالیت", "2025-06-12 10:12:23", "2025-06-12 10:12:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1334", "713", "عملیات توسط WP Cron شروع شد", "2025-06-12 10:12:23", "2025-06-12 10:12:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1335", "713", "عملیات توسط WP Cron کامل شد", "2025-06-12 10:12:23", "2025-06-12 10:12:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1336", "714", "عملیات توسط WP Cron شروع شد", "2025-06-12 10:12:23", "2025-06-12 10:12:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1337", "714", "عملیات توسط WP Cron کامل شد", "2025-06-12 10:12:23", "2025-06-12 10:12:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1338", "715", "ایجاد فعالیت", "2025-06-12 10:12:30", "2025-06-12 10:12:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1339", "716", "ایجاد فعالیت", "2025-06-12 10:12:36", "2025-06-12 10:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1340", "715", "عملیات توسط Async Request شروع شد", "2025-06-12 10:12:37", "2025-06-12 10:12:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1341", "715", "عملیات توسط Async Request کامل شد", "2025-06-12 10:12:37", "2025-06-12 10:12:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1342", "716", "عملیات توسط Async Request شروع شد", "2025-06-12 10:12:37", "2025-06-12 10:12:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1343", "716", "عملیات توسط Async Request کامل شد", "2025-06-12 10:12:37", "2025-06-12 10:12:37");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "208", "ووکامرس", "", "", "", "2020-01-28 15:32:37", "2020-01-28 12:02:37", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "209", "ووکامرس", "", "", "", "2020-01-28 15:33:12", "2020-01-28 12:03:12", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "210", "ووکامرس", "", "", "", "2020-01-28 15:33:39", "2020-01-28 12:03:39", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "211", "ووکامرس", "", "", "", "2020-01-28 15:34:20", "2020-01-28 12:04:20", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "212", "ووکامرس", "", "", "", "2020-01-28 15:34:57", "2020-01-28 12:04:57", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "zomorod", "9ae585f6782daf137775_20250612104947", "20", "2025-06-12 10:50:11", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-12 10:49:47\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:8:\"10.11.11\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:7:\"zomorod\";s:4:\"Hash\";s:35:\"9ae585f6782daf137775_20250612104947\";s:8:\"NameHash\";s:43:\"zomorod_9ae585f6782daf137775_20250612104947\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:53:\"zomorod_9ae585f6782daf137775_20250612104947_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.9\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:55:\"zomorod_9ae585f6782daf137775_20250612104947_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/home/demoiran/public_html/zomorod\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2845;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:17911;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-12 10:49:47\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:8:\"10.11.11\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:7:\"zomorod\";s:4:\"Hash\";s:35:\"9ae585f6782daf137775_20250612104947\";s:8:\"NameHash\";s:43:\"zomorod_9ae585f6782daf137775_20250612104947\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:61:\"zomorod_9ae585f6782daf137775_20250612104947_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:48:\"/home/demoiran/public_html/zomorod/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:56:\"zomorod_9ae585f6782daf137775_20250612104947_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:123:\"/home/demoiran/public_html/zomorod/wp-content/backups-dup-lite/tmp/zomorod_9ae585f6782daf137775_20250612104947_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:43:\"/home/demoiran/public_html/zomorod/wp-admin\";i:1;s:46:\"/home/demoiran/public_html/zomorod/wp-includes\";i:2;s:55:\"/home/demoiran/public_html/zomorod/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:34:\"/home/demoiran/public_html/zomorod\";i:1;s:34:\"/home/demoiran/public_html/zomorod\";i:2;s:45:\"/home/demoiran/public_html/zomorod/wp-content\";i:3;s:53:\"/home/demoiran/public_html/zomorod/wp-content/uploads\";i:4;s:53:\"/home/demoiran/public_html/zomorod/wp-content/plugins\";i:5;s:56:\"/home/demoiran/public_html/zomorod/wp-content/mu-plugins\";i:6;s:52:\"/home/demoiran/public_html/zomorod/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:66:\"/home/demoiran/public_html/zomorod/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://demo.iran-woodmart.ir/zomorod", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://demo.iran-woodmart.ir/zomorod", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "دموی زمرد وودمارت", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "یک سایت دیگر با وردپرس فارسی", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@iran-woodmart.ir", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:319:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:31:\"^wishlist/([^/]*)/page/([^/]*)?\";s:62:\"index.php?page_id=40&wishlist_id=$matches[1]&paged=$matches[2]\";s:23:\"^wishlist/page/([^/]*)?\";s:38:\"index.php?page_id=40&paged=$matches[1]\";s:19:\"^wishlist/([^/]*)/?\";s:44:\"index.php?page_id=40&wishlist_id=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_layout/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_layout=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_woo_lv/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_woo_lv=$matches[1]&embed=true\";s:36:\"woodmart_woo_lv/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_woo_lv=$matches[1]&tb=1\";s:44:\"woodmart_woo_lv/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_woo_lv/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_woo_lv/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_woo_lv=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_woo_lv/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_woo_lv=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_woo_lv/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_woo_lv/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_woo_lv=$matches[1]&page=$matches[2]\";s:32:\"woodmart_woo_lv/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_woo_lv/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_woo_lv/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_woo_lv/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:53:\"woodmart_woo_fbt/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?woodmart_woo_fbt=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"project-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:45:\"project-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:26:\"project-cat/(.+?)/embed/?$\";s:44:\"index.php?project-cat=$matches[1]&embed=true\";s:38:\"project-cat/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project-cat=$matches[1]&paged=$matches[2]\";s:20:\"project-cat/(.+?)/?$\";s:33:\"index.php?project-cat=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=13&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:27:\"(.?.+?)/waitlist(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&waitlist=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:6:{i:0;s:25:\"duplicator/duplicator.php\";i:1;s:23:\"elementor/elementor.php\";i:2;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:3;s:23:\"revslider/revslider.php\";i:4;s:27:\"woocommerce/woocommerce.php\";i:5;s:31:\"woodmart-core/woodmart-core.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "58975", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "blank", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:6:{i:3;a:4:{s:5:\"title\";s:21:\"بهداشت شخصی\";s:4:\"text\";s:377:\"<ul>\n 	<li>سلامت عمومی</li>\n 	<li>بهداشت سالمندان</li>\n 	<li>بهداشت جنسی</li>\n 	<li>بهداشت بانوان</li>\n 	<li>بهداشت دهان و دندان</li>\n 	<li><a href=\"https://iran-woodmart.ir/product/%d9%82%d8%a7%d9%84%d8%a8-%d9%88%d9%88%d8%af%d9%85%d8%a7%d8%b1%d8%aa/\" target=\"_blank\" rel=\"noopener\">قالب Woodmart</a></li>\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:4;a:4:{s:5:\"title\";s:14:\"مرادانه\";s:4:\"text\";s:190:\"<ul>\r\n 	<li>محصولات بدن آقایان</li>\r\n 	<li>اصلاح آقایان</li>\r\n 	<li>محصولات موی آقایان</li>\r\n 	<li>محصولات پوست آقایان</li>\r\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:5;a:4:{s:5:\"title\";s:28:\"لوازم شخصی برقی\";s:4:\"text\";s:180:\"<ul>\r\n 	<li>حالت دهنده های برقی</li>\r\n 	<li>اصلاح صورت و بدن</li>\r\n 	<li>سایر لوازم شخصی برقی</li>\r\n 	<li>خشک کن ها</li>\r\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:6;a:4:{s:5:\"title\";s:10:\"سالنی\";s:4:\"text\";s:242:\"<ul>\r\n 	<li>تجهیزات آرایشگاهی</li>\r\n 	<li>کتاب و جزوه</li>\r\n 	<li>اپیلاسیون</li>\r\n 	<li>کاشت و طراحی ناخن</li>\r\n 	<li>اکستنشن</li>\r\n 	<li>ابزار آرایش و پیرایش</li>\r\n</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:8;a:4:{s:5:\"title\";s:41:\"اعتماد شما افتخار ماست\";s:4:\"text\";s:328:\"<img class=\"alignnone size-full wp-image-170\" src=\"https://demo.iran-woodmart.ir/zomorod/wp-content/uploads/2020/01/enamad.png\" alt=\"\" width=\"150\" height=\"150\" /> <img class=\"alignnone size-full wp-image-171\" src=\"https://demo.iran-woodmart.ir/zomorod/wp-content/uploads/2020/01/samandehi.png\" alt=\"\" width=\"150\" height=\"150\" />\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:2:{s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Atlantic/Azores", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "13", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "admin_email_lifespan", "1762714869", "yes");
INSERT INTO `wp_options` VALUES("94", "initial_db_version", "45805", "yes");
INSERT INTO `wp_options` VALUES("95", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:128:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:36:\"vc_access_rules_post_types/cms_block\";b:1;s:36:\"vc_access_rules_post_types/portfolio\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:43:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:14:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:102:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:16:\"create_customers\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("96", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("97", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "sidebars_widgets", "a:16:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:5:{i:0;s:24:\"wd-widget-stock-status-2\";i:1;s:26:\"woocommerce_price_filter-3\";i:2;s:32:\"woocommerce_product_categories-2\";i:3;s:34:\"woodmart-woocommerce-layered-nav-3\";i:4;s:34:\"woodmart-woocommerce-layered-nav-2\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:1:{i:0;s:21:\"woodmart-html-block-2\";}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:1:{i:0;s:6:\"text-3\";}s:8:\"footer-3\";a:1:{i:0;s:6:\"text-4\";}s:8:\"footer-4\";a:1:{i:0;s:6:\"text-5\";}s:8:\"footer-5\";a:1:{i:0;s:6:\"text-6\";}s:8:\"footer-6\";a:1:{i:0;s:6:\"text-8\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("104", "cron", "a:28:{i:1749725420;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1749725841;a:1:{s:40:\"woodmart_wishlist_send_promotional_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1749725923;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1749726240;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1749726620;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1749726824;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1749728559;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1749728707;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1749729817;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"b60cc2a666ce180fccae65fd313af7bb\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1097;}}}}i:1749732152;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749737845;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749739506;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749739507;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1749739580;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749739582;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749742952;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1749744630;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749750823;a:1:{s:37:\"puc_cron_check_updates_theme-woodmart\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1749754723;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749756129;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1749772800;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749807762;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1750082400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1750186650;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1750262757;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1750536152;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1751017412;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("117", "theme_mods_twentytwenty", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1580136427;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "off");
INSERT INTO `wp_options` VALUES("144", "current_theme", "Woodmart", "yes");
INSERT INTO `wp_options` VALUES("145", "theme_mods_woodmart", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:16;s:11:\"mobile-menu\";i:16;}s:18:\"custom_css_post_id\";i:716;}", "yes");
INSERT INTO `wp_options` VALUES("146", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("147", "woodmart_token", "1", "yes");
INSERT INTO `wp_options` VALUES("148", "woodmart_is_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("152", "woocommerce_store_address", "تهران", "yes");
INSERT INTO `wp_options` VALUES("153", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("154", "woocommerce_store_city", "تهران", "yes");
INSERT INTO `wp_options` VALUES("155", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `wp_options` VALUES("156", "woocommerce_store_postcode", "12345678", "yes");
INSERT INTO `wp_options` VALUES("157", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("158", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("159", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("160", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_options` VALUES("161", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("162", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("163", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("164", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("165", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("166", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("167", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("168", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("169", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("170", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("171", "woocommerce_shop_page_id", "6", "yes");
INSERT INTO `wp_options` VALUES("172", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("173", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("174", "woocommerce_placeholder_image", "5", "yes");
INSERT INTO `wp_options` VALUES("175", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("176", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("177", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("178", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("179", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("180", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("181", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("182", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("183", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("184", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("185", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("186", "woocommerce_stock_email_recipient", "mj.masoud@yahoo.com", "no");
INSERT INTO `wp_options` VALUES("187", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("188", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("189", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("190", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("191", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("192", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("193", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("194", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("195", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("196", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("197", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("198", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("199", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("200", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("201", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("202", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("203", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("204", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("205", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("206", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("207", "woocommerce_enable_guest_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("208", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wp_options` VALUES("209", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("210", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("211", "woocommerce_registration_generate_username", "no", "no");
INSERT INTO `wp_options` VALUES("212", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_options` VALUES("213", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("214", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("215", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("216", "woocommerce_registration_privacy_policy_text", "", "yes");
INSERT INTO `wp_options` VALUES("217", "woocommerce_checkout_privacy_policy_text", "", "yes");
INSERT INTO `wp_options` VALUES("218", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("219", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("220", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("221", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_options` VALUES("222", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("223", "woocommerce_email_from_name", "قالب وودمارت ژاکت", "no");
INSERT INTO `wp_options` VALUES("224", "woocommerce_email_from_address", "zhaket.woodmart@gmail.com", "no");
INSERT INTO `wp_options` VALUES("225", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("226", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("227", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wp_options` VALUES("228", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("229", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("230", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("231", "woocommerce_cart_page_id", "7", "no");
INSERT INTO `wp_options` VALUES("232", "woocommerce_checkout_page_id", "8", "no");
INSERT INTO `wp_options` VALUES("233", "woocommerce_myaccount_page_id", "9", "no");
INSERT INTO `wp_options` VALUES("234", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("235", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("236", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_options` VALUES("237", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("238", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("239", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("240", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("241", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("242", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("243", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("244", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("245", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("246", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("247", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("248", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("249", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("250", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("251", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("252", "woocommerce_show_marketplace_suggestions", "no", "off");
INSERT INTO `wp_options` VALUES("253", "woocommerce_single_image_width", "800", "yes");
INSERT INTO `wp_options` VALUES("254", "woocommerce_thumbnail_image_width", "400", "yes");
INSERT INTO `wp_options` VALUES("255", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("256", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("257", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("258", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("259", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("262", "default_product_cat", "15", "yes");
INSERT INTO `wp_options` VALUES("267", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-b.tools\";i:1;s:22:\"themepunch-ext-c.tools\";i:2;s:22:\"themepunch-ext-a.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("268", "revslider_server_refresh", "1747797290", "yes");
INSERT INTO `wp_options` VALUES("269", "revslider-update-check-short", "1749584079", "yes");
INSERT INTO `wp_options` VALUES("270", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("271", "revslider-update-hash", "4ce4a00c1affd6621ebe4426ae95427c", "yes");
INSERT INTO `wp_options` VALUES("272", "revslider-latest-version", "6.7.34", "yes");
INSERT INTO `wp_options` VALUES("273", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("274", "revslider-notices", "a:4:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-b.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("275", "revslider-addons", "O:8:\"stdClass\":36:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"559\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"558\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"567\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"551\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:4:\"1471\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:6:\"6.7.32\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"6.7.8\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2025-04-16\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"545\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"569\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"555\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"552\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"553\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"556\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2025-01-15\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"547\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"550\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2024-12-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"554\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2024-12-06\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"562\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"616\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:6:\"6.7.21\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"575\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"549\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2025-02-18\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"564\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2024-12-19\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"571\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:81:\"//updates.themepunch-ext-b.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"560\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"561\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"566\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-shapeburst-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"613\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:26:\"revslider-shapeburst-addon\";s:12:\"version_from\";s:6:\"6.7.23\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"ShapeBurst\";s:6:\"line_1\";s:8:\"Shape...\";s:6:\"line_2\";s:9:\"and Burst\";s:9:\"available\";s:5:\"7.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"670\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_shape_burst.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_shape_burst.jpg\";s:7:\"img_md5\";s:32:\"2b1b6cb4613bdfcfff4c8c46660be8f5\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:1:{i:0;s:14:\"Visual Effects\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"570\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"548\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("276", "revslider-library-check", "1749523058", "yes");
INSERT INTO `wp_options` VALUES("277", "revslider-library-hash", "324e6ba47fb68dfb7f1bd5b0b203bdc5", "yes");
INSERT INTO `wp_options` VALUES("278", "rs-library", "a:3:{s:4:\"hash\";s:32:\"324e6ba47fb68dfb7f1bd5b0b203bdc5\";s:7:\"objects\";a:417:{i:0;a:13:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14130;s:4:\"orig\";i:220294;}}i:1;a:13:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:27127;s:4:\"orig\";i:1192484;}}i:2;a:13:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:1745;s:4:\"orig\";i:36243;}}i:3;a:13:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10511;s:4:\"orig\";i:102067;}}i:4;a:13:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18581;s:4:\"orig\";i:776243;}}i:5;a:13:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4745;s:4:\"orig\";i:330658;}}i:6;a:13:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4461;s:4:\"orig\";i:109963;}}i:7;a:13:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6790;s:4:\"orig\";i:407746;}}i:8;a:13:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18710;s:4:\"orig\";i:985569;}}i:9;a:13:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6113;s:4:\"orig\";i:75865;}}i:10;a:13:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8145;s:4:\"orig\";i:400329;}}i:11;a:13:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5251;s:4:\"orig\";i:358141;}}i:12;a:13:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:127536;s:4:\"orig\";i:838279;}}i:13;a:13:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4081;s:4:\"orig\";i:22391;}}i:14;a:13:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9331;s:4:\"orig\";i:516465;}}i:15;a:13:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:463818;}}i:16;a:13:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6359;s:4:\"orig\";i:102578;}}i:17;a:13:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22078;s:4:\"orig\";i:1107904;}}i:18;a:13:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15660;s:4:\"orig\";i:355784;}}i:19;a:13:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5586;s:4:\"orig\";i:106514;}}i:20;a:13:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20909;s:4:\"orig\";i:988589;}}i:21;a:13:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6807;s:4:\"orig\";i:604409;}}i:22;a:13:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10484;s:4:\"orig\";i:229243;}}i:23;a:13:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6034;s:4:\"orig\";i:516575;}}i:24;a:13:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30999;s:4:\"orig\";i:627862;}}i:25;a:13:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:658948;}}i:26;a:13:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16432;s:4:\"orig\";i:531684;}}i:27;a:13:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15860;s:4:\"orig\";i:212685;}}i:28;a:13:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12774;s:4:\"orig\";i:290128;}}i:29;a:13:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8558;s:4:\"orig\";i:264887;}}i:30;a:13:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23349;s:4:\"orig\";i:324946;}}i:31;a:13:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18439;s:4:\"orig\";i:583276;}}i:32;a:13:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8475;s:4:\"orig\";i:241613;}}i:33;a:13:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12227;s:4:\"orig\";i:465092;}}i:34;a:13:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23476;s:4:\"orig\";i:838985;}}i:35;a:13:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:128594;s:4:\"orig\";i:323284;}}i:36;a:13:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15763;s:4:\"orig\";i:606028;}}i:37;a:13:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8743;s:4:\"orig\";i:230696;}}i:38;a:13:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18213;s:4:\"orig\";i:963650;}}i:39;a:13:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9109;s:4:\"orig\";i:190560;}}i:40;a:13:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7469;s:4:\"orig\";i:161910;}}i:41;a:13:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8883;s:4:\"orig\";i:223813;}}i:42;a:13:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13021;s:4:\"orig\";i:334845;}}i:43;a:13:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20718;s:4:\"orig\";i:626836;}}i:44;a:13:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:135139;s:4:\"orig\";i:761240;}}i:45;a:13:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13099;s:4:\"orig\";i:337348;}}i:46;a:13:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13096;s:4:\"orig\";i:413010;}}i:47;a:13:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8043;s:4:\"orig\";i:146037;}}i:48;a:13:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37011;s:4:\"orig\";i:2569343;}}i:49;a:13:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:118650;s:4:\"orig\";i:83713;}}i:50;a:13:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16941;s:4:\"orig\";i:419726;}}i:51;a:13:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23620;s:4:\"orig\";i:734047;}}i:52;a:13:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21088;s:4:\"orig\";i:683735;}}i:53;a:13:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121307;s:4:\"orig\";i:454357;}}i:54;a:13:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39586;s:4:\"orig\";i:1296460;}}i:55;a:13:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21396;s:4:\"orig\";i:835061;}}i:56;a:13:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9545;s:4:\"orig\";i:197811;}}i:57;a:13:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12033;s:4:\"orig\";i:168991;}}i:58;a:13:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39587;s:4:\"orig\";i:1318549;}}i:59;a:13:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:137321;s:4:\"orig\";i:211275;}}i:60;a:13:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14164;s:4:\"orig\";i:731428;}}i:61;a:13:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:130362;s:4:\"orig\";i:908876;}}i:62;a:13:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:132862;s:4:\"orig\";i:925492;}}i:63;a:13:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119015;s:4:\"orig\";i:133010;}}i:64;a:13:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28476;s:4:\"orig\";i:203448;}}i:65;a:13:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:120592;s:4:\"orig\";i:133753;}}i:66;a:13:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119554;s:4:\"orig\";i:160622;}}i:67;a:13:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14058;s:4:\"orig\";i:98209;}}i:68;a:13:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:126007;s:4:\"orig\";i:137953;}}i:69;a:13:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124418;s:4:\"orig\";i:108064;}}i:70;a:13:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125639;s:4:\"orig\";i:131820;}}i:71;a:13:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11948;s:4:\"orig\";i:74707;}}i:72;a:13:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:115633;s:4:\"orig\";i:176188;}}i:73;a:13:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121535;s:4:\"orig\";i:315586;}}i:74;a:13:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:133693;s:4:\"orig\";i:907152;}}i:75;a:13:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11689;s:4:\"orig\";i:183976;}}i:76;a:13:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119147;s:4:\"orig\";i:164255;}}i:77;a:13:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9499;s:4:\"orig\";i:358634;}}i:78;a:13:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14203;s:4:\"orig\";i:523017;}}i:79;a:13:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10702;s:4:\"orig\";i:121030;}}i:80;a:13:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9002;s:4:\"orig\";i:338072;}}i:81;a:13:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121622;s:4:\"orig\";i:211345;}}i:82;a:13:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:122962;s:4:\"orig\";i:353407;}}i:83;a:13:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7170;s:4:\"orig\";i:118827;}}i:84;a:13:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125910;s:4:\"orig\";i:126452;}}i:85;a:13:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12207;s:4:\"orig\";i:177730;}}i:86;a:13:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13663;s:4:\"orig\";i:833006;}}i:87;a:13:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9899;s:4:\"orig\";i:247486;}}i:88;a:13:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7169;s:4:\"orig\";i:522980;}}i:89;a:13:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12411;s:4:\"orig\";i:1051815;}}i:90;a:13:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14974;s:4:\"orig\";i:1082610;}}i:91;a:13:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26819;s:4:\"orig\";i:1283468;}}i:92;a:13:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22713;s:4:\"orig\";i:1335327;}}i:93;a:13:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5513;s:4:\"orig\";i:477513;}}i:94;a:13:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24077;s:4:\"orig\";i:1392352;}}i:95;a:13:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11502;s:4:\"orig\";i:779077;}}i:96;a:13:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7975;s:4:\"orig\";i:323107;}}i:97;a:13:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:129564;s:4:\"orig\";i:432451;}}i:98;a:13:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6743;s:4:\"orig\";i:479348;}}i:99;a:13:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3910;s:4:\"orig\";i:246373;}}i:100;a:13:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9677;s:4:\"orig\";i:154608;}}i:101;a:13:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5998;s:4:\"orig\";i:447839;}}i:102;a:13:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10117;s:4:\"orig\";i:559800;}}i:103;a:13:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24853;s:4:\"orig\";i:1214851;}}i:104;a:13:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18163;s:4:\"orig\";i:1098732;}}i:105;a:13:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5457;s:4:\"orig\";i:320148;}}i:106;a:13:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13313;s:4:\"orig\";i:828871;}}i:107;a:13:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5901;s:4:\"orig\";i:268842;}}i:108;a:13:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37178;s:4:\"orig\";i:1972817;}}i:109;a:13:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26589;s:4:\"orig\";i:851135;}}i:110;a:13:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13334;s:4:\"orig\";i:225651;}}i:111;a:13:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17640;s:4:\"orig\";i:719125;}}i:112;a:13:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8897;s:4:\"orig\";i:83416;}}i:113;a:13:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29174;s:4:\"orig\";i:1663503;}}i:114;a:13:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3668;s:4:\"orig\";i:69153;}}i:115;a:13:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3179;s:4:\"orig\";i:45340;}}i:116;a:13:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21907;s:4:\"orig\";i:937495;}}i:117;a:13:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124560;s:4:\"orig\";i:575796;}}i:118;a:13:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20553;s:4:\"orig\";i:734042;}}i:119;a:13:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9048;s:4:\"orig\";i:129827;}}i:120;a:13:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19226;s:4:\"orig\";i:758093;}}i:121;a:13:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12387;s:4:\"orig\";i:472820;}}i:122;a:13:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10972;s:4:\"orig\";i:380716;}}i:123;a:13:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12394;s:4:\"orig\";i:959761;}}i:124;a:13:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11474;s:4:\"orig\";i:284282;}}i:125;a:13:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13395;s:4:\"orig\";i:519568;}}i:126;a:13:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15367;s:4:\"orig\";i:364626;}}i:127;a:13:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16174;s:4:\"orig\";i:265728;}}i:128;a:13:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7677;s:4:\"orig\";i:256526;}}i:129;a:13:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12408;s:4:\"orig\";i:354771;}}i:130;a:13:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17621;s:4:\"orig\";i:673109;}}i:131;a:13:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9464;s:4:\"orig\";i:180683;}}i:132;a:13:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16190;s:4:\"orig\";i:381967;}}i:133;a:13:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26583;s:4:\"orig\";i:792941;}}i:134;a:13:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17464;s:4:\"orig\";i:394604;}}i:135;a:13:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19126;s:4:\"orig\";i:403268;}}i:136;a:13:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16597;s:4:\"orig\";i:552042;}}i:137;a:13:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16027;s:4:\"orig\";i:430912;}}i:138;a:13:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15961;s:4:\"orig\";i:706482;}}i:139;a:13:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20286;s:4:\"orig\";i:704324;}}i:140;a:13:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10077;s:4:\"orig\";i:197347;}}i:141;a:13:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14092;s:4:\"orig\";i:517927;}}i:142;a:13:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18629;s:4:\"orig\";i:620706;}}i:143;a:13:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10220;s:4:\"orig\";i:348322;}}i:144;a:13:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6348;s:4:\"orig\";i:211494;}}i:145;a:13:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9826;s:4:\"orig\";i:377551;}}i:146;a:13:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13862;s:4:\"orig\";i:454028;}}i:147;a:13:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18636;s:4:\"orig\";i:785357;}}i:148;a:13:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17409;s:4:\"orig\";i:996686;}}i:149;a:13:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12053;s:4:\"orig\";i:916937;}}i:150;a:13:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3887;s:4:\"orig\";i:154603;}}i:151;a:13:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16305;s:4:\"orig\";i:483681;}}i:152;a:13:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12105;s:4:\"orig\";i:314746;}}i:153;a:13:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18137;s:4:\"orig\";i:371805;}}i:154;a:13:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11586;s:4:\"orig\";i:354781;}}i:155;a:13:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9848;s:4:\"orig\";i:195359;}}i:156;a:13:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10089;s:4:\"orig\";i:218538;}}i:157;a:13:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16403;s:4:\"orig\";i:547096;}}i:158;a:13:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19188;s:4:\"orig\";i:371592;}}i:159;a:13:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15157;s:4:\"orig\";i:658386;}}i:160;a:13:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24833;s:4:\"orig\";i:942816;}}i:161;a:13:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:345362;}}i:162;a:13:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15665;s:4:\"orig\";i:407640;}}i:163;a:13:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19443;s:4:\"orig\";i:844506;}}i:164;a:13:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15564;s:4:\"orig\";i:573777;}}i:165;a:13:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13337;s:4:\"orig\";i:762091;}}i:166;a:13:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16746;s:4:\"orig\";i:365391;}}i:167;a:13:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12699;s:4:\"orig\";i:427166;}}i:168;a:13:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4748;s:4:\"orig\";i:238506;}}i:169;a:13:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19043;s:4:\"orig\";i:595277;}}i:170;a:13:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11863;s:4:\"orig\";i:228649;}}i:171;a:13:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10878;s:4:\"orig\";i:313238;}}i:172;a:13:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7596;s:4:\"orig\";i:193734;}}i:173;a:13:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9305;s:4:\"orig\";i:223763;}}i:174;a:13:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23289;s:4:\"orig\";i:699269;}}i:175;a:13:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16638;s:4:\"orig\";i:415507;}}i:176;a:13:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11706;s:4:\"orig\";i:310875;}}i:177;a:13:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18880;s:4:\"orig\";i:531273;}}i:178;a:13:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20175;s:4:\"orig\";i:554813;}}i:179;a:13:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6818;s:4:\"orig\";i:122809;}}i:180;a:13:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8776;s:4:\"orig\";i:190452;}}i:181;a:13:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52127;s:4:\"orig\";i:352596;}}i:182;a:13:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8878;s:4:\"orig\";i:183427;}}i:183;a:13:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15887;s:4:\"orig\";i:368977;}}i:184;a:13:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15080;s:4:\"orig\";i:707157;}}i:185;a:13:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5473;s:4:\"orig\";i:288675;}}i:186;a:13:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19262;s:4:\"orig\";i:513524;}}i:187;a:13:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9810;s:4:\"orig\";i:317981;}}i:188;a:13:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15773;s:4:\"orig\";i:519696;}}i:189;a:13:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32647;s:4:\"orig\";i:350074;}}i:190;a:13:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14643;s:4:\"orig\";i:314424;}}i:191;a:13:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19823;s:4:\"orig\";i:511473;}}i:192;a:13:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37262;s:4:\"orig\";i:1590451;}}i:193;a:13:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13647;s:4:\"orig\";i:408622;}}i:194;a:13:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10075;s:4:\"orig\";i:216586;}}i:195;a:13:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10969;s:4:\"orig\";i:405945;}}i:196;a:13:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9975;s:4:\"orig\";i:257177;}}i:197;a:13:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9598;s:4:\"orig\";i:300066;}}i:198;a:13:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7588;s:4:\"orig\";i:184359;}}i:199;a:13:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9507;s:4:\"orig\";i:290246;}}i:200;a:13:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14875;s:4:\"orig\";i:324145;}}i:201;a:13:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18138;s:4:\"orig\";i:736181;}}i:202;a:13:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10664;s:4:\"orig\";i:411404;}}i:203;a:13:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11609;s:4:\"orig\";i:273103;}}i:204;a:13:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16837;s:4:\"orig\";i:456937;}}i:205;a:13:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13774;s:4:\"orig\";i:385875;}}i:206;a:13:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12285;s:4:\"orig\";i:546492;}}i:207;a:13:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12631;s:4:\"orig\";i:540206;}}i:208;a:13:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9964;s:4:\"orig\";i:309994;}}i:209;a:13:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13683;s:4:\"orig\";i:369417;}}i:210;a:13:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15941;s:4:\"orig\";i:475914;}}i:211;a:13:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17854;s:4:\"orig\";i:371480;}}i:212;a:13:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17441;s:4:\"orig\";i:507045;}}i:213;a:13:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:32396;s:4:\"orig\";i:750503;}}i:214;a:13:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25355;s:4:\"orig\";i:517171;}}i:215;a:13:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30467;s:4:\"orig\";i:1076108;}}i:216;a:13:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17629;s:4:\"orig\";i:804567;}}i:217;a:13:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12952;s:4:\"orig\";i:489898;}}i:218;a:13:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11065;s:4:\"orig\";i:384178;}}i:219;a:13:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6262;s:4:\"orig\";i:198960;}}i:220;a:13:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16353;s:4:\"orig\";i:245636;}}i:221;a:13:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6048;s:4:\"orig\";i:133907;}}i:222;a:13:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15187;s:4:\"orig\";i:450326;}}i:223;a:13:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17977;s:4:\"orig\";i:582673;}}i:224;a:13:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20171;s:4:\"orig\";i:617346;}}i:225;a:13:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14937;s:4:\"orig\";i:227355;}}i:226;a:13:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9789;s:4:\"orig\";i:321713;}}i:227;a:13:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18374;s:4:\"orig\";i:642218;}}i:228;a:13:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17332;s:4:\"orig\";i:791283;}}i:229;a:13:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28854;s:4:\"orig\";i:1228379;}}i:230;a:13:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7529;s:4:\"orig\";i:263779;}}i:231;a:13:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18101;s:4:\"orig\";i:617407;}}i:232;a:13:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18049;s:4:\"orig\";i:757700;}}i:233;a:13:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18133;s:4:\"orig\";i:633849;}}i:234;a:13:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24430;s:4:\"orig\";i:954378;}}i:235;a:13:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16738;s:4:\"orig\";i:664032;}}i:236;a:13:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17594;s:4:\"orig\";i:503413;}}i:237;a:13:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15558;s:4:\"orig\";i:508616;}}i:238;a:13:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14665;s:4:\"orig\";i:429256;}}i:239;a:13:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20433;s:4:\"orig\";i:1162968;}}i:240;a:13:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10872;s:4:\"orig\";i:289488;}}i:241;a:13:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17988;s:4:\"orig\";i:602577;}}i:242;a:13:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9794;s:4:\"orig\";i:352053;}}i:243;a:13:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:370551;}}i:244;a:13:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10397;s:4:\"orig\";i:280660;}}i:245;a:13:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26832;s:4:\"orig\";i:677097;}}i:246;a:13:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13591;s:4:\"orig\";i:846550;}}i:247;a:13:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12138;s:4:\"orig\";i:511326;}}i:248;a:13:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14005;s:4:\"orig\";i:392648;}}i:249;a:13:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11612;s:4:\"orig\";i:688650;}}i:250;a:13:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28096;s:4:\"orig\";i:766943;}}i:251;a:13:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17419;s:4:\"orig\";i:759716;}}i:252;a:13:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10910;s:4:\"orig\";i:191059;}}i:253;a:13:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24825;s:4:\"orig\";i:706226;}}i:254;a:13:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11091;s:4:\"orig\";i:300143;}}i:255;a:13:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15004;s:4:\"orig\";i:475888;}}i:256;a:13:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13155;s:4:\"orig\";i:683645;}}i:257;a:13:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15305;s:4:\"orig\";i:655207;}}i:258;a:13:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17740;s:4:\"orig\";i:745183;}}i:259;a:13:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17442;s:4:\"orig\";i:641873;}}i:260;a:13:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16088;s:4:\"orig\";i:241567;}}i:261;a:13:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8512;s:4:\"orig\";i:267430;}}i:262;a:13:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25804;s:4:\"orig\";i:908234;}}i:263;a:13:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4691;s:4:\"orig\";i:108160;}}i:264;a:13:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12753;s:4:\"orig\";i:218714;}}i:265;a:13:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19312;s:4:\"orig\";i:438345;}}i:266;a:13:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16224;s:4:\"orig\";i:409547;}}i:267;a:13:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22344;s:4:\"orig\";i:432904;}}i:268;a:13:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9431;s:4:\"orig\";i:220442;}}i:269;a:13:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29538;s:4:\"orig\";i:733632;}}i:270;a:13:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12859;s:4:\"orig\";i:430959;}}i:271;a:13:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13413;s:4:\"orig\";i:324558;}}i:272;a:13:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11553;s:4:\"orig\";i:146076;}}i:273;a:13:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21184;s:4:\"orig\";i:537577;}}i:274;a:13:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14134;s:4:\"orig\";i:245565;}}i:275;a:13:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16035;s:4:\"orig\";i:401592;}}i:276;a:13:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12906;s:4:\"orig\";i:483885;}}i:277;a:13:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:80956;}}i:278;a:13:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11452;s:4:\"orig\";i:175118;}}i:279;a:13:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12170;s:4:\"orig\";i:236860;}}i:280;a:13:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10268;s:4:\"orig\";i:117315;}}i:281;a:13:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12485;s:4:\"orig\";i:374567;}}i:282;a:13:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8401;s:4:\"orig\";i:203253;}}i:283;a:13:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12578;s:4:\"orig\";i:287796;}}i:284;a:13:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8484;s:4:\"orig\";i:199508;}}i:285;a:13:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16659;s:4:\"orig\";i:524922;}}i:286;a:13:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9240;s:4:\"orig\";i:109310;}}i:287;a:13:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8288;s:4:\"orig\";i:216553;}}i:288;a:13:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6855;s:4:\"orig\";i:234043;}}i:289;a:13:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12347;s:4:\"orig\";i:238706;}}i:290;a:13:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7748;s:4:\"orig\";i:169462;}}i:291;a:13:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10402;s:4:\"orig\";i:358403;}}i:292;a:13:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12887;s:4:\"orig\";i:261525;}}i:293;a:13:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:2963;s:4:\"orig\";i:30890;}}i:294;a:13:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10266;s:4:\"orig\";i:183341;}}i:295;a:13:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8156;s:4:\"orig\";i:102119;}}i:296;a:13:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10271;s:4:\"orig\";i:138495;}}i:297;a:13:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11654;s:4:\"orig\";i:171098;}}i:298;a:13:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10569;s:4:\"orig\";i:437331;}}i:299;a:13:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15739;s:4:\"orig\";i:446809;}}i:300;a:13:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9456;s:4:\"orig\";i:206722;}}i:301;a:13:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13833;s:4:\"orig\";i:341185;}}i:302;a:13:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10647;s:4:\"orig\";i:193025;}}i:303;a:13:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6239;s:4:\"orig\";i:48178;}}i:304;a:13:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14454;s:4:\"orig\";i:454843;}}i:305;a:13:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7734;s:4:\"orig\";i:119909;}}i:306;a:13:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11927;s:4:\"orig\";i:209224;}}i:307;a:13:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9609;s:4:\"orig\";i:230249;}}i:308;a:13:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12396;s:4:\"orig\";i:290596;}}i:309;a:14:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25803;s:11:\"video_thumb\";i:2753823;s:5:\"cover\";i:127867;s:4:\"orig\";i:5991847;}}i:310;a:14:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19154;s:11:\"video_thumb\";i:4783500;s:5:\"cover\";i:97843;s:4:\"orig\";i:12408832;}}i:311;a:14:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28284;s:11:\"video_thumb\";i:2150510;s:5:\"cover\";i:124176;s:4:\"orig\";i:7726114;}}i:312;a:14:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23354;s:11:\"video_thumb\";i:3635377;s:5:\"cover\";i:106283;s:4:\"orig\";i:12688465;}}i:313;a:14:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29858;s:11:\"video_thumb\";i:9614915;s:5:\"cover\";i:153660;s:4:\"orig\";i:13424151;}}i:314;a:14:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19155;s:11:\"video_thumb\";i:2361089;s:5:\"cover\";i:103588;s:4:\"orig\";i:14717688;}}i:315;a:14:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:11719;s:11:\"video_thumb\";i:4841259;s:5:\"cover\";i:40309;s:4:\"orig\";i:11715637;}}i:316;a:14:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:56469;s:11:\"video_thumb\";i:5107558;s:5:\"cover\";i:273635;s:4:\"orig\";i:13833056;}}i:317;a:14:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:30439;s:11:\"video_thumb\";i:3864288;s:5:\"cover\";i:133345;s:4:\"orig\";i:13159814;}}i:318;a:14:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31267;s:11:\"video_thumb\";i:2732735;s:5:\"cover\";i:173636;s:4:\"orig\";i:5536475;}}i:319;a:14:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:29090;s:11:\"video_thumb\";i:4861363;s:5:\"cover\";i:188894;s:4:\"orig\";i:13731609;}}i:320;a:14:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31123;s:11:\"video_thumb\";i:1386258;s:5:\"cover\";i:219740;s:4:\"orig\";i:6479275;}}i:321;a:14:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21091;s:11:\"video_thumb\";i:11134706;s:5:\"cover\";i:115059;s:4:\"orig\";i:12313637;}}i:322;a:14:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19624;s:11:\"video_thumb\";i:3913179;s:5:\"cover\";i:118864;s:4:\"orig\";i:14700830;}}i:323;a:14:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:45123;s:11:\"video_thumb\";i:2547876;s:5:\"cover\";i:268587;s:4:\"orig\";i:8823724;}}i:324;a:14:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:33867;s:11:\"video_thumb\";i:5972511;s:5:\"cover\";i:172632;s:4:\"orig\";i:13869858;}}i:325;a:14:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16185;s:11:\"video_thumb\";i:4097952;s:5:\"cover\";i:160912;s:4:\"orig\";i:12307362;}}i:326;a:14:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9324;s:11:\"video_thumb\";i:1843046;s:5:\"cover\";i:94919;s:4:\"orig\";i:4938526;}}i:327;a:14:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:13455;s:11:\"video_thumb\";i:5101194;s:5:\"cover\";i:66493;s:4:\"orig\";i:11852447;}}i:328;a:14:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20003;s:11:\"video_thumb\";i:1696754;s:5:\"cover\";i:103202;s:4:\"orig\";i:12515577;}}i:329;a:14:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19377;s:11:\"video_thumb\";i:3861934;s:5:\"cover\";i:101592;s:4:\"orig\";i:13370749;}}i:330;a:14:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31120;s:11:\"video_thumb\";i:2732488;s:5:\"cover\";i:190596;s:4:\"orig\";i:13625169;}}i:331;a:14:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17475;s:11:\"video_thumb\";i:1248121;s:5:\"cover\";i:203284;s:4:\"orig\";i:4921567;}}i:332;a:14:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26132;s:11:\"video_thumb\";i:5777142;s:5:\"cover\";i:138198;s:4:\"orig\";i:12817212;}}i:333;a:14:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40668;s:11:\"video_thumb\";i:3711074;s:5:\"cover\";i:243587;s:4:\"orig\";i:12354374;}}i:334;a:14:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:41275;s:11:\"video_thumb\";i:2631988;s:5:\"cover\";i:330226;s:4:\"orig\";i:8304831;}}i:335;a:14:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:54209;s:11:\"video_thumb\";i:4596191;s:5:\"cover\";i:335804;s:4:\"orig\";i:13306988;}}i:336;a:14:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:75484;s:11:\"video_thumb\";i:3134686;s:5:\"cover\";i:461854;s:4:\"orig\";i:20337064;}}i:337;a:14:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:25915;s:11:\"video_thumb\";i:2352326;s:5:\"cover\";i:136931;s:4:\"orig\";i:12104254;}}i:338;a:14:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:40965;s:11:\"video_thumb\";i:8637814;s:5:\"cover\";i:195812;s:4:\"orig\";i:13878956;}}i:339;a:14:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19037;s:11:\"video_thumb\";i:3065043;s:5:\"cover\";i:65493;s:4:\"orig\";i:12935967;}}i:340;a:14:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:24344;s:11:\"video_thumb\";i:1911296;s:5:\"cover\";i:192540;s:4:\"orig\";i:4631422;}}i:341;a:14:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23517;s:11:\"video_thumb\";i:4899641;s:5:\"cover\";i:86737;s:4:\"orig\";i:12281833;}}i:342;a:14:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:31844;s:11:\"video_thumb\";i:4412295;s:5:\"cover\";i:154844;s:4:\"orig\";i:10753079;}}i:343;a:14:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14905;s:11:\"video_thumb\";i:3394055;s:5:\"cover\";i:73276;s:4:\"orig\";i:11722124;}}i:344;a:14:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:48591;s:11:\"video_thumb\";i:5268295;s:5:\"cover\";i:211021;s:4:\"orig\";i:11990742;}}i:345;a:14:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27863;s:11:\"video_thumb\";i:2674570;s:5:\"cover\";i:119321;s:4:\"orig\";i:11602755;}}i:346;a:14:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:27505;s:11:\"video_thumb\";i:3025283;s:5:\"cover\";i:144357;s:4:\"orig\";i:13176990;}}i:347;a:14:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22543;s:11:\"video_thumb\";i:1327376;s:5:\"cover\";i:111224;s:4:\"orig\";i:4727340;}}i:348;a:14:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:34936;s:11:\"video_thumb\";i:3198076;s:5:\"cover\";i:160493;s:4:\"orig\";i:12804022;}}i:349;a:14:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:28883;s:11:\"video_thumb\";i:4750283;s:5:\"cover\";i:153687;s:4:\"orig\";i:13054569;}}i:350;a:14:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:53693;s:11:\"video_thumb\";i:9780815;s:5:\"cover\";i:341419;s:4:\"orig\";i:13738077;}}i:351;a:14:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:9494;s:11:\"video_thumb\";i:942533;s:5:\"cover\";i:52833;s:4:\"orig\";i:6629299;}}i:352;a:14:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22781;s:11:\"video_thumb\";i:2415073;s:5:\"cover\";i:126450;s:4:\"orig\";i:11684367;}}i:353;a:14:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:22296;s:11:\"video_thumb\";i:1465206;s:5:\"cover\";i:73047;s:4:\"orig\";i:4008355;}}i:354;a:14:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19851;s:11:\"video_thumb\";i:3023599;s:5:\"cover\";i:25426;s:4:\"orig\";i:12847145;}}i:355;a:14:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:18002;s:11:\"video_thumb\";i:1791449;s:5:\"cover\";i:101725;s:4:\"orig\";i:13746552;}}i:356;a:14:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:8176;s:11:\"video_thumb\";i:4255586;s:5:\"cover\";i:75455;s:4:\"orig\";i:10948491;}}i:357;a:14:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:46567;s:11:\"video_thumb\";i:3789289;s:5:\"cover\";i:25425;s:4:\"orig\";i:15943336;}}i:358;a:14:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:26927;s:11:\"video_thumb\";i:2605391;s:5:\"cover\";i:149830;s:4:\"orig\";i:13232415;}}i:359;a:14:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20000;s:11:\"video_thumb\";i:655504;s:5:\"cover\";i:620066;s:4:\"orig\";i:13229794;}}i:360;a:14:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23213;s:11:\"video_thumb\";i:498407;s:5:\"cover\";i:308442;s:4:\"orig\";i:11108924;}}i:361;a:14:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21648;s:11:\"video_thumb\";i:109062;s:5:\"cover\";i:305957;s:4:\"orig\";i:6267674;}}i:362;a:14:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19198;s:11:\"video_thumb\";i:326656;s:5:\"cover\";i:554701;s:4:\"orig\";i:10151652;}}i:363;a:14:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14725;s:11:\"video_thumb\";i:72977;s:5:\"cover\";i:72535;s:4:\"orig\";i:4938006;}}i:364;a:14:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:12165;s:11:\"video_thumb\";i:256975;s:5:\"cover\";i:340550;s:4:\"orig\";i:9691449;}}i:365;a:14:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:36900;s:11:\"video_thumb\";i:920631;s:5:\"cover\";i:949012;s:4:\"orig\";i:13422013;}}i:366;a:14:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17289;s:11:\"video_thumb\";i:137402;s:5:\"cover\";i:300574;s:4:\"orig\";i:7528458;}}i:367;a:14:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16562;s:11:\"video_thumb\";i:161004;s:5:\"cover\";i:291708;s:4:\"orig\";i:7596827;}}i:368;a:14:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19186;s:11:\"video_thumb\";i:404406;s:5:\"cover\";i:496556;s:4:\"orig\";i:15358645;}}i:369;a:14:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11778;s:5:\"video\";i:126230;}}i:370;a:14:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9342;s:5:\"video\";i:258890;}}i:371;a:14:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22925;s:5:\"video\";i:337622;}}i:372;a:14:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13590;s:5:\"video\";i:143116;}}i:373;a:14:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12603;s:5:\"video\";i:267056;}}i:374;a:14:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11225;s:5:\"video\";i:104722;}}i:375;a:14:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16221;s:5:\"video\";i:183244;}}i:376;a:14:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15072;s:5:\"video\";i:90577;}}i:377;a:14:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11741;s:5:\"video\";i:96061;}}i:378;a:14:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15979;s:5:\"video\";i:136040;}}i:379;a:14:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13637;s:5:\"video\";i:98053;}}i:380;a:14:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14892;s:5:\"video\";i:125449;}}i:381;a:14:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16568;s:5:\"video\";i:127133;}}i:382;a:14:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19099;s:5:\"video\";i:202784;}}i:383;a:14:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21756;s:5:\"video\";i:295899;}}i:384;a:14:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20783;s:5:\"video\";i:279347;}}i:385;a:14:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17862;s:5:\"video\";i:111140;}}i:386;a:14:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10799;s:5:\"video\";i:49269;}}i:387;a:14:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14442;s:5:\"video\";i:143950;}}i:388;a:14:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16819;s:5:\"video\";i:142842;}}i:389;a:14:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12575;s:5:\"video\";i:106541;}}i:390;a:14:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12931;s:5:\"video\";i:84922;}}i:391;a:14:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18105;s:5:\"video\";i:184683;}}i:392;a:14:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13440;s:5:\"video\";i:104866;}}i:393;a:14:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17477;s:5:\"video\";i:147765;}}i:394;a:14:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36069;s:5:\"video\";i:104559;}}i:395;a:14:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20095;s:5:\"video\";i:60429;}}i:396;a:14:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:38056;s:5:\"video\";i:45726;}}i:397;a:14:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:54736;s:5:\"video\";i:26685;}}i:398;a:14:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34717;s:5:\"video\";i:16283;}}i:399;a:14:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25700;s:5:\"video\";i:38602;}}i:400;a:14:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:55897;s:5:\"video\";i:21279;}}i:401;a:14:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39579;s:5:\"video\";i:22677;}}i:402;a:14:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41903;s:5:\"video\";i:65515;}}i:403;a:14:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25902;s:5:\"video\";i:15295;}}i:404;a:14:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40029;s:5:\"video\";i:28970;}}i:405;a:14:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21834;s:5:\"video\";i:21250;}}i:406;a:14:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:36633;s:5:\"video\";i:51973;}}i:407;a:14:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22669;s:5:\"video\";i:46598;}}i:408;a:14:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:52537;s:5:\"video\";i:29580;}}i:409;a:14:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34343;s:5:\"video\";i:18413;}}i:410;a:14:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20519;s:5:\"video\";i:25391;}}i:411;a:14:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16265;s:5:\"video\";i:75634;}}i:412;a:14:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:41495;s:5:\"video\";i:49692;}}i:413;a:14:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:40417;s:5:\"video\";i:80078;}}i:414;a:14:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:34150;s:5:\"video\";i:23500;}}i:415;a:14:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15426;s:5:\"video\";i:21651;}}i:416;a:14:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:33524;s:5:\"video\";i:46449;}}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "off");
INSERT INTO `wp_options` VALUES("279", "revslider-templates-check", "1749657201", "yes");
INSERT INTO `wp_options` VALUES("280", "revslider-templates-hash", "9f9773c128859bb65e5a5402c51783de", "yes");
INSERT INTO `wp_options` VALUES("281", "rs-templates-new", "", "off");
INSERT INTO `wp_options` VALUES("282", "rs-templates", "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", "off");
INSERT INTO `wp_options` VALUES("286", "recently_activated", "a:1:{s:33:\"mime-types-plus/mimetypesplus.php\";i:1749722691;}", "off");
INSERT INTO `wp_options` VALUES("287", "woocommerce_admin_notices", "a:1:{i:0;s:14:\"template_files\";}", "yes");
INSERT INTO `wp_options` VALUES("288", "revslider_update_version", "6.7.24", "yes");
INSERT INTO `wp_options` VALUES("289", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"pxrR8bIo9xHWKDuK7P9rSJVgDWAoTtXm\";}", "yes");
INSERT INTO `wp_options` VALUES("291", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("292", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("293", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("294", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("295", "widget_woocommerce_price_filter", "a:2:{i:3;a:1:{s:5:\"title\";s:19:\"فیلتر قیمت\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("296", "widget_woocommerce_product_categories", "a:2:{i:2;a:8:{s:5:\"title\";s:32:\"دسته‌های محصولات\";s:7:\"orderby\";s:5:\"order\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("297", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("298", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("299", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("300", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("301", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("302", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("303", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("304", "widget_nav_mega_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("305", "widget_woodmart-banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("306", "widget_woodmart-author-information", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("307", "widget_woodmart-instagram", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("308", "widget_woodmart-html-block", "a:2:{i:2;a:1:{s:2:\"id\";s:2:\"35\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("309", "widget_woodmart-recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("310", "widget_woodmart-twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("311", "widget_woodmart-user-panel", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("312", "widget_woodmart-woocommerce-layered-nav", "a:3:{i:2;a:8:{s:5:\"title\";s:17:\"فیلتر رنگ\";s:9:\"attribute\";s:5:\"color\";s:8:\"category\";s:3:\"all\";s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";}i:3;a:8:{s:5:\"title\";s:34:\"فیلتر برند محصولات\";s:9:\"attribute\";s:5:\"brand\";s:8:\"category\";s:3:\"all\";s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:3:\"off\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("313", "widget_woodmart-woocommerce-sort-by", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("314", "widget_woodmart-price-filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("315", "widget_woodmart-ajax-search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("317", "vc_version", "6.2.0", "yes");
INSERT INTO `wp_options` VALUES("319", "xts-default_header-css-data", ".whb-top-bar .wd-dropdown {\n	margin-top: 0px;\n}\n\n.whb-top-bar .wd-dropdown:after {\n	height: 10px;\n}\n\n.whb-sticked .whb-general-header .wd-dropdown {\n	margin-top: 7.5px;\n}\n\n.whb-sticked .whb-general-header .wd-dropdown:after {\n	height: 17.5px;\n}\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n.whb-sticked .whb-header-bottom .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-sticked .whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n\n\n\n@media (min-width: 1025px) {\n		.whb-top-bar-inner {\n		height: 40px;\n		max-height: 40px;\n	}\n\n		.whb-sticked .whb-top-bar-inner {\n		height: 40px;\n		max-height: 40px;\n	}\n		\n		.whb-general-header-inner {\n		height: 90px;\n		max-height: 90px;\n	}\n\n		.whb-sticked .whb-general-header-inner {\n		height: 55px;\n		max-height: 55px;\n	}\n		\n		.whb-header-bottom-inner {\n		height: 50px;\n		max-height: 50px;\n	}\n\n		.whb-sticked .whb-header-bottom-inner {\n		height: 50px;\n		max-height: 50px;\n	}\n		\n	\n	}\n\n@media (max-width: 1024px) {\n	\n		.whb-general-header-inner {\n		height: 60px;\n		max-height: 60px;\n	}\n	\n	\n	\n	}\n		\n.whb-top-bar {\n	background-color: rgba(255, 255, 255, 1);border-color: rgba(217, 217, 217, 1);border-bottom-width: 1px;border-bottom-style: solid;\n}\n\n.whb-general-header {\n	border-color: rgba(129, 129, 129, 0.2);border-bottom-width: 1px;border-bottom-style: solid;\n}\n.whb-n75lp1zoots235dih121 .menu-opener { background-color: rgba(255, 255, 255, 1); }.whb-n75lp1zoots235dih121.wd-more-cat:not(.wd-show-cat) .item-level-0:nth-child(n+7):not(:last-child) {\n				    display: none;\n				}.\n				wd-more-cat .item-level-0:nth-child(n+7) {\n				    animation: wd-fadeIn .3s ease both;\n				}\n.whb-header-bottom {\n	border-color: rgba(222, 222, 222, 1);border-bottom-width: 1px;border-bottom-style: solid;\n}\n", "yes");
INSERT INTO `wp_options` VALUES("320", "xts-default_header-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("321", "xts-default_header-version", "6.0.2", "yes");
INSERT INTO `wp_options` VALUES("322", "xts-theme_settings_default-css-data", "@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//demo.iran-woodmart.ir/zomorod/wp-content/themes/woodmart/fonts/woodmart-font-1-400.woff2?v=8.2.2\") format(\"woff2\");\n}\n\n@font-face {\n	font-family: \"star\";\n	font-weight: 400;\n	font-style: normal;\n	src: url(\"//demo.iran-woodmart.ir/zomorod/wp-content/plugins/woocommerce/assets/fonts/star.eot?#iefix\") format(\"embedded-opentype\"), url(\"//demo.iran-woodmart.ir/zomorod/wp-content/plugins/woocommerce/assets/fonts/star.woff\") format(\"woff\"), url(\"//demo.iran-woodmart.ir/zomorod/wp-content/plugins/woocommerce/assets/fonts/star.ttf\") format(\"truetype\"), url(\"//demo.iran-woodmart.ir/zomorod/wp-content/plugins/woocommerce/assets/fonts/star.svg#star\") format(\"svg\");\n}\n\n@font-face {\n	font-family: \"WooCommerce\";\n	font-weight: 400;\n	font-style: normal;\n	src: url(\"//demo.iran-woodmart.ir/zomorod/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.eot?#iefix\") format(\"embedded-opentype\"), url(\"//demo.iran-woodmart.ir/zomorod/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.woff\") format(\"woff\"), url(\"//demo.iran-woodmart.ir/zomorod/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.ttf\") format(\"truetype\"), url(\"//demo.iran-woodmart.ir/zomorod/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.svg#WooCommerce\") format(\"svg\");\n}\n\n:root {\n	--wd-text-font: \"bakh\", Arial, Helvetica, sans-serif;\n	--wd-text-font-weight: 400;\n	--wd-text-color: #777777;\n	--wd-text-font-size: 14px;\n	--wd-title-font: \"bakh\", Arial, Helvetica, sans-serif;\n	--wd-title-font-weight: 900;\n	--wd-title-color: #242424;\n	--wd-entities-title-font: \"bakh\", Arial, Helvetica, sans-serif;\n	--wd-entities-title-font-weight: 500;\n	--wd-entities-title-color: #333333;\n	--wd-entities-title-color-hover: rgb(51 51 51 / 65%);\n	--wd-alternative-font: \"bakh\", Arial, Helvetica, sans-serif;\n	--wd-widget-title-font: \"bakh\", Arial, Helvetica, sans-serif;\n	--wd-widget-title-font-weight: 600;\n	--wd-widget-title-transform: uppercase;\n	--wd-widget-title-color: #333;\n	--wd-widget-title-font-size: 16px;\n	--wd-header-el-font: \"bakh\", Arial, Helvetica, sans-serif;\n	--wd-header-el-font-weight: 400;\n	--wd-header-el-transform: uppercase;\n	--wd-header-el-font-size: 14px;\n	--wd-primary-color: rgb(202,169,132);\n	--wd-alternative-color: #fbbc34;\n	--wd-link-color: #333333;\n	--wd-link-color-hover: #242424;\n	--btn-default-bgcolor: #f7f7f7;\n	--btn-default-bgcolor-hover: #efefef;\n	--btn-accented-bgcolor: rgb(202,169,132);\n	--btn-accented-bgcolor-hover: rgb(24,51,53);\n	--wd-form-brd-width: 2px;\n	--notices-success-bg: #459647;\n	--notices-success-color: #fff;\n	--notices-warning-bg: #E0B252;\n	--notices-warning-color: #fff;\n	--wd-sticky-btn-height: 95px;\n}\n.wd-popup.wd-age-verify {\n	--wd-popup-width: 500px;\n}\n.wd-popup.wd-promo-popup {\n	background-color: #111111;\n	background-image: none;\n	background-repeat: no-repeat;\n	background-size: contain;\n	background-position: left center;\n	--wd-popup-width: 800px;\n}\n:is(.woodmart-woocommerce-layered-nav, .wd-product-category-filter) .wd-scroll-content {\n	max-height: 233px;\n}\n.wd-page-title {\n	background-color: #e8e8e8;\n	background-image: none;\n	background-size: cover;\n	background-position: center center;\n}\n.wd-footer {\n	background-color: rgb(24,51,53);\n	background-image: none;\n}\n.wd-popup.popup-quick-view {\n	--wd-popup-width: 920px;\n}\n\n@media (max-width: 1024px) {\n	:root {\n		--wd-sticky-btn-height: 95px;\n	}\n\n}\n\n@media (max-width: 768.98px) {\n	:root {\n		--wd-sticky-btn-height: 42px;\n	}\n\n}\n:root{\n--wd-container-w: 1222px;\n--wd-form-brd-radius: 5px;\n--btn-default-color: #333;\n--btn-default-color-hover: #333;\n--btn-accented-color: #fff;\n--btn-accented-color-hover: #fff;\n--btn-default-brd-radius: 5px;\n--btn-default-box-shadow: none;\n--btn-default-box-shadow-hover: none;\n--btn-accented-brd-radius: 5px;\n--btn-accented-box-shadow: none;\n--btn-accented-box-shadow-hover: none;\n--wd-brd-radius: 8px;\n}\n\n@media (min-width: 1222px) {\nsection.elementor-section.wd-section-stretch > .elementor-container {\nmargin-left: auto;\nmargin-right: auto;\n}\n}\n\nrs-slides :is([data-type=text],[data-type=button]) {\nfont-family: bakh !important;\n}\nrs-slides :is(h1,h2,h3,h4,h5,h6)[data-type=text] {\nfont-family: bakh !important;\n}\n\n@font-face {\n	font-family: \"bakh\";\n	src: url(\"//demo.iran-woodmart.ir/zomorod/wp-content/uploads/2025/06/YekanBakhFaNum-Regular.woff2\") format(\"woff2\");\n	font-weight: 400;\n	font-style: normal;\n}\n\n@font-face {\n	font-family: \"bakh\";\n	src: url(\"//demo.iran-woodmart.ir/zomorod/wp-content/uploads/2025/06/YekanBakhFaNum-ExtraBold.woff2\") format(\"woff2\");\n	font-weight: 900;\n	font-style: normal;\n}\n\n.woodmart-button-wrapper.inline-element {\r\n    margin-bottom: 0px;\r\n}\r\n.product-grid-item .wd-product-countdown, .product-grid-item .wd-stock-progress-bar {\r\n    margin-bottom: 10px;\r\n}\r\n.wd-hover-standard .wd-add-btn {\r\n    margin-top: 5px;\r\n    margin-bottom: 15px;\r\n}\r\n.promo-banner .promo-banner-image {\r\n    border-radius: 15px;\r\n}\r\n.product-grid-item.woodmart-hover-tiled .hover-img img, .product-grid-item.woodmart-hover-tiled .product-image-link img {\r\n    width: 100%;\r\n    padding: 20px;\r\n}\r\n.woodmart-hover-tiled .product-wrapper {\r\n    border-radius: 10px;\r\n    overflow: hidden;\r\n	background: #fff;\r\n}\r\n.labels-rectangular .product-label {\r\n    padding: 5px 10px;\r\n    font-size: 12px;\r\n    border-radius: 15px;\r\n    margin-right: 5px;\r\n}\r\n.product-grid-item.wd-hover-standard {\r\n    text-align: center;\r\n    background: #fff;\r\n    border-radius: 10px;\r\n    overflow: hidden;\r\n}\r\n.blog-design-masonry .post-title {\r\n    font-size: 16px !important;\r\n}", "on");
INSERT INTO `wp_options` VALUES("324", "xts-theme_settings_default-version", "8.2.2", "on");
INSERT INTO `wp_options` VALUES("334", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("338", "xts-woodmart-options", "a:821:{s:12:\"last_message\";s:4:\"save\";s:14:\"default_header\";s:13:\"header_246188\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:0:\"\";s:15:\"age_verify_text\";s:171:\"<h4 style=\"text-align: center\">Are you over 18?</h4>\r\n<p style=\"text-align: center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:134:\"<h4 style=\"text-align: center\">Access forbidden</h4>\r\n<p style=\"text-align: center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:0:\"\";s:24:\"promo_popup_content_type\";s:4:\"text\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:13:\"popup_padding\";s:0:\"\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:0:\"\";s:12:\"cookies_text\";s:224:\"ما از کوکی ها برای بهبود کارکردن شما با سایت استفاده می کنیم. با استفاده از این سایت شما استفاده ما از کوکی ها را پذیرفته اید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:1:\"#\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:21:\"[html_block id=\"398\"]\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"55\";s:27:\"header_banner_mobile_height\";s:2:\"50\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:13:\"search_by_sku\";s:1:\"1\";s:28:\"search_by_product_categories\";s:1:\"0\";s:21:\"search_by_product_tag\";s:1:\"0\";s:28:\"search_by_product_attributes\";s:1:\"0\";s:24:\"search_by_product_brands\";s:1:\"0\";s:21:\"enqueue_posts_results\";s:0:\"\";s:27:\"search_posts_results_column\";s:1:\"2\";s:16:\"popular_requests\";s:0:\"\";s:15:\"search_synonyms\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:17:\"relevanssi_search\";s:1:\"0\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1222\";s:11:\"main_layout\";s:10:\"full-width\";s:13:\"sidebar_width\";s:1:\"3\";s:17:\"hide_main_sidebar\";s:1:\"0\";s:24:\"hide_main_sidebar_tablet\";s:1:\"1\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";b:1;s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:0:\"\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"1\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:0:\"\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:0:\"\";s:23:\"stretch_product_desktop\";b:0;s:22:\"stretch_product_tablet\";b:0;s:22:\"stretch_product_mobile\";b:0;s:25:\"product_title_lines_limit\";s:3:\"two\";s:22:\"show_empty_star_rating\";b:0;s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";b:0;s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"1\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";b:0;s:23:\"grid_stock_progress_bar\";s:1:\"1\";s:14:\"shop_countdown\";s:1:\"1\";s:22:\"categories_under_title\";s:0:\"\";s:18:\"brands_under_title\";s:0:\"\";s:15:\"sku_under_title\";b:0;s:18:\"show_reviews_count\";b:0;s:17:\"categories_design\";s:7:\"default\";s:19:\"categories_rounding\";s:0:\"\";s:31:\"custom_categories_rounding_size\";s:0:\"\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_subcategories\";b:0;s:29:\"hide_categories_product_count\";s:0:\"\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:0:\"\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:0:\"\";s:10:\"shop_title\";s:1:\"0\";s:15:\"shop_categories\";s:1:\"0\";s:25:\"shop_categories_ancestors\";s:0:\"\";s:25:\"show_categories_neighbors\";s:0:\"\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:0:\"\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";b:0;s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"30\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"3\";i:1;s:1:\"4\";i:2;s:1:\"2\";}s:16:\"products_masonry\";s:0:\"\";s:24:\"products_different_sizes\";s:0:\"\";s:13:\"shop_per_page\";s:1:\"9\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:7:\"9,24,36\";s:15:\"shop_pagination\";s:7:\"infinit\";s:25:\"load_more_button_page_url\";b:1;s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"233\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:0:\"\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";i:30;s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";b:0;s:17:\"hide_price_filter\";b:0;s:20:\"shop_filters_content\";s:3:\"590\";s:24:\"shop_filters_always_open\";s:0:\"\";s:18:\"shop_filters_close\";s:0:\"\";s:17:\"page-title-design\";s:7:\"default\";s:15:\"page-title-size\";s:5:\"small\";s:16:\"title-background\";a:7:{s:5:\"color\";s:7:\"#e8e8e8\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:4:\"dark\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:0:\"\";s:23:\"yoast_pages_breadcrumbs\";s:0:\"\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:7:\"widgets\";s:13:\"footer-layout\";s:2:\"12\";s:17:\"footer_html_block\";s:0:\"\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:13:\"rgb(24,51,53)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:5:\"light\";s:13:\"sticky_footer\";s:0:\"\";s:23:\"collapse_footer_widgets\";s:0:\"\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"1\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:213:\"<p> <a href=\"https://iran-woodmart.ir/product/%d9%82%d8%a7%d9%84%d8%a8-%d9%88%d9%88%d8%af%d9%85%d8%a7%d8%b1%d8%aa/\">قالب وودمارت </a>- تمامی حقوق برای این سایت محفوظ است.</p>\";s:11:\"copyrights2\";s:87:\"<img src=\"https://demo.iran-woodmart.ir/zomorod/wp-content/uploads/2020/01/897987.png\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:0:\"\";s:11:\"font-family\";s:4:\"bakh\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:0:\"\";s:11:\"font-family\";s:4:\"bakh\";s:11:\"font-weight\";s:3:\"900\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:0:\"\";s:11:\"font-family\";s:4:\"bakh\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:0:\"\";s:11:\"font-family\";s:4:\"bakh\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:0:\"\";s:11:\"font-family\";s:4:\"bakh\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:4:\"bakh\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:4:\"bakh\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:93:\"https://demo.iran-woodmart.ir/zomorod/wp-content/uploads/2025/06/YekanBakhFaNum-Regular.woff2\";s:2:\"id\";s:4:\"1099\";}}i:1;a:4:{s:9:\"font-name\";s:4:\"bakh\";s:11:\"font-weight\";s:3:\"900\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:95:\"https://demo.iran-woodmart.ir/zomorod/wp-content/uploads/2025/06/YekanBakhFaNum-ExtraBold.woff2\";s:2:\"id\";s:4:\"1098\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"1\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:1:\"8\";s:20:\"custom_rounding_size\";s:0:\"\";s:12:\"dark_version\";s:0:\"\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:16:\"rgb(202,169,132)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:7:\"#fbbc34\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:7:\"#242424\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:12:\"semi-rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:4:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:0:{}s:38:\"btns_default_color_scheme_hover_custom\";a:0:{}s:15:\"btns_shop_style\";s:12:\"semi-rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:4:{s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:16:\"rgb(202,169,132)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:13:\"rgb(24,51,53)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:0:{}s:35:\"btns_shop_color_scheme_hover_custom\";a:0:{}s:26:\"advanced_typography_button\";s:0:\"\";s:17:\"form_fields_style\";s:12:\"semi-rounded\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";s:0:\"\";s:22:\"form_placeholder_color\";s:0:\"\";s:14:\"form_brd_color\";s:0:\"\";s:20:\"form_brd_color_focus\";s:0:\"\";s:7:\"form_bg\";s:0:\"\";s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:0:\"\";s:29:\"carousel_arrows_sep_icon_size\";s:0:\"\";s:28:\"carousel_arrows_sep_offset_h\";s:0:\"\";s:28:\"carousel_arrows_sep_offset_v\";s:0:\"\";s:25:\"carousel_arrows_sep_color\";a:0:{}s:31:\"carousel_arrows_sep_color_hover\";a:0:{}s:29:\"carousel_arrows_sep_color_dis\";a:0:{}s:28:\"carousel_arrows_sep_bg_color\";a:0:{}s:34:\"carousel_arrows_sep_bg_color_hover\";a:0:{}s:32:\"carousel_arrows_sep_bg_color_dis\";a:0:{}s:33:\"carousel_arrows_sep_border_radius\";s:0:\"\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:0:\"\";s:32:\"carousel_arrows_sep_border_color\";a:0:{}s:38:\"carousel_arrows_sep_border_color_hover\";a:0:{}s:36:\"carousel_arrows_sep_border_color_dis\";a:0:{}s:36:\"carousel_arrows_sep_box_shadow_color\";a:0:{}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:0:\"\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:0:\"\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:0:\"\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:0:\"\";s:28:\"carousel_arrows_together_gap\";s:0:\"\";s:29:\"carousel_arrows_together_size\";s:0:\"\";s:34:\"carousel_arrows_together_icon_size\";s:0:\"\";s:33:\"carousel_arrows_together_offset_h\";s:0:\"\";s:33:\"carousel_arrows_together_offset_v\";s:0:\"\";s:30:\"carousel_arrows_together_color\";a:0:{}s:36:\"carousel_arrows_together_color_hover\";a:0:{}s:34:\"carousel_arrows_together_color_dis\";a:0:{}s:33:\"carousel_arrows_together_bg_color\";a:0:{}s:39:\"carousel_arrows_together_bg_color_hover\";a:0:{}s:37:\"carousel_arrows_together_bg_color_dis\";a:0:{}s:38:\"carousel_arrows_together_border_radius\";s:0:\"\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:0:\"\";s:37:\"carousel_arrows_together_border_color\";a:0:{}s:43:\"carousel_arrows_together_border_color_hover\";a:0:{}s:41:\"carousel_arrows_together_border_color_dis\";a:0:{}s:41:\"carousel_arrows_together_box_shadow_color\";a:0:{}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:0:\"\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:0:\"\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:0:\"\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:0:\"\";s:19:\"carousel_pagin_size\";s:0:\"\";s:23:\"carousel_pagin_bg_color\";a:0:{}s:29:\"carousel_pagin_bg_color_hover\";a:0:{}s:30:\"carousel_pagin_bg_color_active\";a:0:{}s:28:\"carousel_pagin_border_radius\";s:0:\"\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:0:\"\";s:27:\"carousel_pagin_border_color\";a:0:{}s:33:\"carousel_pagin_border_color_hover\";a:0:{}s:34:\"carousel_pagin_border_color_active\";a:0:{}s:25:\"carousel_scrollbar_height\";s:0:\"\";s:24:\"carousel_scrollbar_width\";s:0:\"\";s:27:\"carousel_scrollbar_bg_color\";a:0:{}s:32:\"carousel_scrollbar_drag_bg_color\";a:0:{}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:0:{}s:11:\"blog_design\";s:7:\"masonry\";s:12:\"blog_masonry\";b:0;s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";b:1;s:12:\"blog_columns\";s:1:\"3\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:10:\"pagination\";s:19:\"blog_archive_layout\";s:13:\"sidebar-right\";s:26:\"blog_archive_sidebar_width\";i:3;s:25:\"blog_archive_hide_sidebar\";s:1:\"0\";s:32:\"blog_archive_hide_sidebar_tablet\";s:1:\"1\";s:32:\"blog_archive_hide_sidebar_mobile\";s:1:\"1\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"100\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:20:\"parts_published_date\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:17:\"blog_hide_sidebar\";s:1:\"0\";s:24:\"blog_hide_sidebar_tablet\";s:1:\"1\";s:24:\"blog_hide_sidebar_mobile\";s:1:\"1\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:19:\"blog_published_date\";s:1:\"1\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:29:\"single_post_builder_post_data\";s:0:\"\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:0:\"\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:2:\"30\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:2:\"12\";s:20:\"portfolio_pagination\";s:10:\"pagination\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:0:\"\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:32:\"single_project_builder_post_data\";s:0:\"\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:0:\"\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"1\";s:21:\"show_sku_in_mini_cart\";b:0;s:16:\"show_sku_in_cart\";b:0;s:25:\"show_sku_in_checkout_page\";b:0;s:26:\"show_sku_in_thank_you_page\";b:0;s:23:\"show_sku_in_email_order\";b:0;s:16:\"show_sku_on_ajax\";s:0:\"\";s:12:\"catalog_mode\";s:0:\"\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:0:\"\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";b:0;s:35:\"single_product_swatches_limit_count\";i:10;s:29:\"swatches_use_variation_images\";s:0:\"\";s:20:\"swatches_labels_name\";s:1:\"1\";s:27:\"swatches_scroll_top_desktop\";s:1:\"1\";s:26:\"swatches_scroll_top_mobile\";s:0:\"\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:29:\"show_filtered_variation_image\";b:0;s:17:\"hide_larger_price\";s:0:\"\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:11:\"rectangular\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:0:{}s:21:\"sale_label_text_color\";a:0:{}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:0:{}s:20:\"new_label_text_color\";a:0:{}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:0:{}s:20:\"hot_label_text_color\";a:0:{}s:20:\"stock_label_bg_color\";a:0:{}s:22:\"stock_label_text_color\";a:0:{}s:24:\"attribute_label_bg_color\";a:0:{}s:26:\"attribute_label_text_color\";a:0:{}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:18:\"brand_tab_priority\";s:0:\"\";s:14:\"brand_tab_name\";s:0:\"\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:2:\"42\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:12:\"availability\";i:2;s:3:\"sku\";}s:18:\"empty_compare_text\";s:0:\"\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:18:\"cart_totals_layout\";s:8:\"layout-1\";s:27:\"update_cart_quantity_change\";b:0;s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:0:\"\";s:20:\"single_sidebar_width\";s:1:\"2\";s:27:\"single_product_hide_sidebar\";s:1:\"0\";s:34:\"single_product_hide_sidebar_tablet\";s:1:\"1\";s:34:\"single_product_hide_sidebar_mobile\";s:1:\"1\";s:20:\"single_product_style\";s:1:\"1\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"1\";s:22:\"product_summary_shadow\";s:1:\"1\";s:17:\"single_full_width\";s:0:\"\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"1\";s:23:\"pagination_main_gallery\";b:0;s:23:\"product_images_captions\";s:0:\"\";s:14:\"thums_position\";s:6:\"bottom\";s:31:\"single_product_grid_columns_gap\";s:0:\"\";s:34:\"single_product_grid_column_desktop\";s:0:\"\";s:33:\"single_product_grid_column_tablet\";s:0:\"\";s:33:\"single_product_grid_column_mobile\";s:0:\"\";s:37:\"single_product_gallery_column_desktop\";i:1;s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";i:3;s:39:\"single_product_thumbnails_items_desktop\";i:4;s:38:\"single_product_thumbnails_items_tablet\";i:4;s:38:\"single_product_thumbnails_items_mobile\";i:3;s:22:\"main_gallery_on_tablet\";b:1;s:22:\"main_gallery_on_mobile\";b:1;s:24:\"main_gallery_center_mode\";b:0;s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";b:1;s:39:\"single_product_thumbnails_gallery_width\";s:0:\"\";s:40:\"single_product_thumbnails_gallery_height\";s:0:\"\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"1\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"1\";s:33:\"sticky_add_to_cart_height_desktop\";i:95;s:32:\"sticky_add_to_cart_height_tablet\";i:95;s:32:\"sticky_add_to_cart_height_mobile\";i:42;s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"summary\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"1\";s:17:\"product_countdown\";s:1:\"1\";s:23:\"sale_countdown_variable\";s:1:\"1\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:18:\"show_product_brand\";s:1:\"0\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"5\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:22:\"enable_description_tab\";s:1:\"1\";s:24:\"description_tab_priority\";s:0:\"\";s:26:\"enable_additional_info_tab\";s:1:\"1\";s:28:\"additional_info_tab_priority\";s:0:\"\";s:18:\"enable_reviews_tab\";s:1:\"1\";s:20:\"reviews_tab_priority\";s:0:\"\";s:27:\"legacy_product_tabs_enabled\";s:1:\"1\";s:20:\"additional_tab_title\";s:0:\"\";s:23:\"additional_tab_priority\";s:0:\"\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:25:\"additional_tab_2_priority\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:25:\"additional_tab_3_priority\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"0\";s:9:\"reg_title\";s:10:\"عضویت\";s:8:\"reg_text\";s:0:\"\";s:11:\"login_title\";s:8:\"ورود\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:963:\".woodmart-button-wrapper.inline-element {\r\n    margin-bottom: 0px;\r\n}\r\n.product-grid-item .wd-product-countdown, .product-grid-item .wd-stock-progress-bar {\r\n    margin-bottom: 10px;\r\n}\r\n.wd-hover-standard .wd-add-btn {\r\n    margin-top: 5px;\r\n    margin-bottom: 15px;\r\n}\r\n.promo-banner .promo-banner-image {\r\n    border-radius: 15px;\r\n}\r\n.product-grid-item.woodmart-hover-tiled .hover-img img, .product-grid-item.woodmart-hover-tiled .product-image-link img {\r\n    width: 100%;\r\n    padding: 20px;\r\n}\r\n.woodmart-hover-tiled .product-wrapper {\r\n    border-radius: 10px;\r\n    overflow: hidden;\r\n	background: #fff;\r\n}\r\n.labels-rectangular .product-label {\r\n    padding: 5px 10px;\r\n    font-size: 12px;\r\n    border-radius: 15px;\r\n    margin-right: 5px;\r\n}\r\n.product-grid-item.wd-hover-standard {\r\n    text-align: center;\r\n    background: #fff;\r\n    border-radius: 10px;\r\n    overflow: hidden;\r\n}\r\n.blog-design-masonry .post-title {\r\n    font-size: 16px !important;\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:0:\"\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:0:\"\";s:12:\"twitter_link\";s:0:\"\";s:12:\"bluesky_link\";s:0:\"\";s:14:\"isntagram_link\";s:1:\"#\";s:12:\"threads_link\";s:0:\"\";s:14:\"pinterest_link\";s:0:\"\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:13:\"whatsapp_link\";s:1:\"#\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:1:\"#\";s:10:\"viber_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:18:\"social_email_links\";b:0;s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:14:\"share_whatsapp\";s:0:\"\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:0:\"\";s:8:\"share_vk\";s:0:\"\";s:8:\"share_ok\";s:0:\"\";s:11:\"share_email\";s:0:\"\";s:19:\"mobile_optimization\";s:0:\"\";s:16:\"load_text_domain\";b:1;s:21:\"disable_gutenberg_css\";s:0:\"\";s:19:\"inline_critical_css\";b:0;s:19:\"advanced_css_notice\";s:0:\"\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";b:0;s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:0:\"\";s:22:\"lazy_loading_bg_images\";b:0;s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";b:0;s:26:\"rocket_delay_js_exclusions\";b:0;s:6:\"cf7_js\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:6:\"always\";s:23:\"font_icon_woff2_preload\";s:0:\"\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:15:\"current_builder\";s:8:\"external\";s:16:\"gutenberg_blocks\";s:1:\"0\";s:29:\"enable_gutenberg_for_products\";s:1:\"0\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"1\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"0\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"1\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:0:\"\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"1\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"0\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:2:\"40\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:0:\"\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:27:\"checkout_show_product_image\";b:0;s:25:\"checkout_product_quantity\";b:0;s:22:\"checkout_remove_button\";b:0;s:24:\"checkout_link_to_product\";b:0;s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:0:\"\";s:15:\"reviews_columns\";i:1;s:22:\"reviews_columns_tablet\";i:1;s:22:\"reviews_columns_mobile\";i:1;s:24:\"reviews_enable_pros_cons\";b:0;s:20:\"reviews_enable_likes\";b:0;s:32:\"show_reviews_purchased_indicator\";b:0;s:15:\"reviews_sorting\";b:0;s:29:\"single_product_comment_images\";s:0:\"\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";b:0;s:22:\"reviews_rating_summary\";b:0;s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";b:0;s:26:\"reviews_rating_by_criteria\";b:0;s:32:\"reviews_criteria_rating_required\";b:0;s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";b:1;s:23:\"checkout_fields_enabled\";b:0;s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:53:\"<p>Add [remainder] to cart and get free shipping!</p>\";s:37:\"shipping_progress_bar_message_success\";s:46:\"<p>Your order qualifies for free shipping!</p>\";s:15:\"buy_now_enabled\";b:0;s:16:\"buy_now_redirect\";s:0:\"\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";i:10;s:17:\"linked_variations\";b:1;s:21:\"show_single_variation\";b:0;s:21:\"hide_variation_parent\";b:0;s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:0:\"\";s:20:\"sold_counter_enabled\";b:0;s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";b:0;s:22:\"sold_counter_timeframe\";i:3;s:29:\"sold_counter_timeframe_period\";s:0:\"\";s:28:\"sold_counter_transient_hours\";i:24;s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:18:\"free_gifts_enabled\";s:1:\"0\";s:16:\"free_gifts_limit\";s:1:\"5\";s:41:\"free_gifts_allow_multiple_identical_gifts\";s:1:\"0\";s:23:\"free_gifts_price_format\";s:4:\"text\";s:17:\"free_gift_on_cart\";b:1;s:25:\"free_gifts_table_location\";s:28:\"woocommerce_after_cart_table\";s:21:\"free_gift_on_checkout\";b:0;s:28:\"show_out_of_stock_at_the_end\";s:1:\"0\";s:16:\"waitlist_enabled\";s:1:\"0\";s:21:\"waitlist_for_loggined\";s:1:\"0\";s:19:\"waitlist_form_state\";s:13:\"current_state\";s:25:\"waitlist_fragments_enable\";s:1:\"0\";s:22:\"waitlist_wait_interval\";s:0:\"\";s:32:\"waitlist_enable_privacy_checkbox\";s:1:\"1\";s:30:\"waitlist_privacy_checkbox_text\";s:60:\"I have read and accept the <strong>[privacy_policy]</strong>\";s:25:\"estimate_delivery_enabled\";b:0;s:40:\"estimate_delivery_show_on_single_product\";b:1;s:35:\"estimate_delivery_show_on_mini_cart\";b:0;s:35:\"estimate_delivery_show_on_cart_page\";b:1;s:39:\"estimate_delivery_show_on_checkout_page\";b:1;s:39:\"estimate_delivery_show_on_order_details\";b:1;s:37:\"estimate_delivery_show_on_email_order\";b:1;s:30:\"estimate_delivery_show_overall\";b:0;s:29:\"estimate_delivery_date_format\";s:0:\"\";s:34:\"estimate_delivery_fragments_enable\";b:0;s:27:\"custom_product_tabs_enabled\";s:1:\"0\";s:21:\"cart_recovery_enabled\";b:0;s:26:\"recover_guest_cart_enabled\";b:0;s:42:\"recover_guest_cart_enable_privacy_checkbox\";b:0;s:40:\"recover_guest_cart_privacy_checkbox_text\";s:446:\"اگر این کادر را علامت بزنید، به ما اجازه می دهید تا برخی از جزئیات خود را در لیست مخاطبین ذخیره کنیم. ممکن است پیام های ایمیلی حاوی اطلاعات تجاری یا تبلیغاتی در مورد این فروشگاه دریافت کنید.\nاطلاعات شخصی جمع آوری شده: آدرس ایمیل، نام و نام خانوادگی.\";s:24:\"abandoned_cart_timeframe\";i:2;s:31:\"abandoned_cart_timeframe_period\";s:0:\"\";s:31:\"abandoned_cart_delete_timeframe\";i:30;s:38:\"abandoned_cart_delete_timeframe_period\";s:0:\"\";s:29:\"abandoned_cart_coupon_enabled\";b:0;s:28:\"abandoned_cart_coupon_prefix\";s:2:\"WD\";s:28:\"abandoned_cart_coupon_amount\";i:10;s:35:\"abandoned_cart_coupon_discount_type\";s:0:\"\";s:34:\"abandoned_cart_delete_used_coupons\";b:1;s:37:\"abandoned_cart_delete_expired_coupons\";b:1;s:31:\"abandoned_cart_coupon_timeframe\";i:1;s:38:\"abandoned_cart_coupon_timeframe_period\";s:0:\"\";s:8:\"last_tab\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("358", "woocommerce_setup_ab_wc_admin_onboarding", "a", "yes");
INSERT INTO `wp_options` VALUES("360", "woocommerce_product_type", "both", "yes");
INSERT INTO `wp_options` VALUES("361", "woocommerce_cheque_settings", "a:1:{s:7:\"enabled\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("362", "woocommerce_bacs_settings", "a:1:{s:7:\"enabled\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("363", "woocommerce_cod_settings", "a:1:{s:7:\"enabled\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_options` VALUES("375", "whb_default_header", "a:4:{s:9:\"structure\";a:3:{s:2:\"id\";s:4:\"root\";s:4:\"type\";s:4:\"root\";s:7:\"content\";a:3:{i:0;a:4:{s:2:\"id\";s:7:\"top-bar\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:7:\"column5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:3:{i:0;a:3:{s:2:\"id\";s:20:\"skeezdsgge7iogsbjfg9\";s:4:\"type\";s:4:\"text\";s:6:\"params\";a:3:{s:7:\"content\";a:3:{s:2:\"id\";s:7:\"content\";s:5:\"value\";s:46:\"فروشگاه اینترنتی وودمارت\";s:4:\"type\";s:6:\"editor\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:1;a:3:{s:2:\"id\";s:20:\"dlxezqgaz9a0do1d9565\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:2;a:3:{s:2:\"id\";s:20:\"lmb8yj2sj6iy2d6pbgkg\";s:4:\"type\";s:4:\"menu\";s:6:\"params\";a:3:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:86:\"%d9%86%d9%88%d8%a7%d8%b1-%d8%a8%d8%a7%d9%84%d8%a7%db%8c-%d8%b3%d8%b1%d8%a8%d8%b1%da%af\";s:4:\"type\";s:6:\"select\";}s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column6\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:7:\"column7\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"61qbocnh2ezx7e7al7jd\";s:4:\"type\";s:6:\"social\";s:6:\"params\";a:7:{s:4:\"type\";a:3:{s:2:\"id\";s:4:\"type\";s:5:\"value\";s:6:\"follow\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:5:\"small\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:5:\"align\";a:3:{s:2:\"id\";s:5:\"align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:4:\"form\";a:3:{s:2:\"id\";s:4:\"form\";s:5:\"value\";s:6:\"circle\";s:4:\"type\";s:8:\"selector\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile1\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"nugd58vqvv5sdr3bc5dd\";s:4:\"type\";s:6:\"social\";s:6:\"params\";a:7:{s:4:\"type\";a:3:{s:2:\"id\";s:4:\"type\";s:5:\"value\";s:5:\"share\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:5:\"small\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:5:\"align\";a:3:{s:2:\"id\";s:5:\"align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"selector\";}s:4:\"form\";a:3:{s:2:\"id\";s:4:\"form\";s:5:\"value\";s:6:\"circle\";s:4:\"type\";s:8:\"selector\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:35;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:1:{s:16:\"background-color\";a:4:{s:1:\"r\";i:255;s:1:\"g\";i:255;s:1:\"b\";i:255;s:1:\"a\";i:1;}}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:3:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:217;s:1:\"g\";i:217;s:1:\"b\";i:217;s:1:\"a\";i:1;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}}}i:1;a:4:{s:2:\"id\";s:14:\"general-header\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:6:{i:0;a:3:{s:2:\"id\";s:7:\"column8\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:8:{i:0;a:3:{s:2:\"id\";s:20:\"5u866sftq6yga790jxf3\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:4:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"2\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:3:\"bag\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}i:1;a:3:{s:2:\"id\";s:20:\"aj3i3sgmkczq8j5etzrz\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:2;a:3:{s:2:\"id\";s:20:\"i8977fqp1lmve3hyjltf\";s:4:\"type\";s:8:\"wishlist\";s:6:\"params\";a:4:{s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:18:\"hide_product_count\";a:3:{s:2:\"id\";s:18:\"hide_product_count\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}i:3;a:3:{s:2:\"id\";s:20:\"8ti5hoe2d2yb4yp246za\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:4;a:3:{s:2:\"id\";s:20:\"5ctl6euocj10e0l74hok\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:5;a:3:{s:2:\"id\";s:20:\"vzfll7h67mfeot4u55e0\";s:4:\"type\";s:7:\"compare\";s:6:\"params\";a:4:{s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:18:\"hide_product_count\";a:3:{s:2:\"id\";s:18:\"hide_product_count\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}i:6;a:3:{s:2:\"id\";s:20:\"2b8mjqhbtvxz16jtxdrd\";s:4:\"type\";s:7:\"account\";s:6:\"params\";a:6:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:13:\"with_username\";a:3:{s:2:\"id\";s:13:\"with_username\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"login_dropdown\";a:3:{s:2:\"id\";s:14:\"login_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"form_display\";a:3:{s:2:\"id\";s:12:\"form_display\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}}}i:7;a:3:{s:2:\"id\";s:20:\"2cc93mk4p68g2ojkml7x\";s:4:\"type\";s:5:\"space\";s:6:\"params\";a:2:{s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column9\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"duljtjrl87kj7pmuut6b\";s:4:\"type\";s:6:\"search\";s:6:\"params\";a:8:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"form\";s:4:\"type\";s:8:\"selector\";}s:12:\"search_style\";a:3:{s:2:\"id\";s:12:\"search_style\";s:5:\"value\";s:7:\"with-bg\";s:4:\"type\";s:8:\"selector\";}s:19:\"categories_dropdown\";a:3:{s:2:\"id\";s:19:\"categories_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:4:\"ajax\";a:3:{s:2:\"id\";s:4:\"ajax\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:17:\"ajax_result_count\";a:3:{s:2:\"id\";s:17:\"ajax_result_count\";s:5:\"value\";i:10;s:4:\"type\";s:6:\"slider\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column10\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"xmf0qymf4r5oje3mdv6f\";s:4:\"type\";s:5:\"space\";s:6:\"params\";a:2:{s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:1;a:3:{s:2:\"id\";s:20:\"250rtwdwz5p8e5b7tpw0\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:4:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:214;s:3:\"url\";s:75:\"https://demo.iran-woodmart.ir/zomorod/wp-content/uploads/2020/01/logo-2.png\";s:5:\"width\";i:174;s:6:\"height\";i:36;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:250;s:4:\"type\";s:6:\"slider\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile2\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"wn5z894j1g5n0yp3eeuz\";s:4:\"type\";s:6:\"burger\";s:6:\"params\";a:8:{s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:5:\"right\";s:4:\"type\";s:8:\"selector\";}s:11:\"search_form\";a:3:{s:2:\"id\";s:11:\"search_form\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:15:\"categories_menu\";a:3:{s:2:\"id\";s:15:\"categories_menu\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:105:\"%d9%85%d9%86%d9%88%db%8c-%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c-%d8%b9%d9%85%d9%88%d8%af%db%8c\";s:4:\"type\";s:6:\"select\";}s:9:\"tabs_swap\";a:3:{s:2:\"id\";s:9:\"tabs_swap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:4;a:3:{s:2:\"id\";s:14:\"column_mobile3\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"g5z57bkgtznbk6v9pll5\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:4:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:214;s:3:\"url\";s:75:\"https://demo.iran-woodmart.ir/zomorod/wp-content/uploads/2020/01/logo-2.png\";s:5:\"width\";i:174;s:6:\"height\";i:36;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:140;s:4:\"type\";s:6:\"slider\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";a:4:{s:2:\"id\";i:214;s:3:\"url\";s:75:\"https://demo.iran-woodmart.ir/zomorod/wp-content/uploads/2020/01/logo-2.png\";s:5:\"width\";i:174;s:6:\"height\";i:36;}s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}}}}}i:5;a:3:{s:2:\"id\";s:14:\"column_mobile4\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"petgsu6di56mzyzuopqb\";s:4:\"type\";s:7:\"account\";s:6:\"params\";a:6:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:13:\"with_username\";a:3:{s:2:\"id\";s:13:\"with_username\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"login_dropdown\";a:3:{s:2:\"id\";s:14:\"login_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"form_display\";a:3:{s:2:\"id\";s:12:\"form_display\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}}}i:1;a:3:{s:2:\"id\";s:20:\"u6cx6mzhiof1qeysah9h\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:4:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"5\";s:4:\"type\";s:8:\"selector\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:3:\"bag\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:90;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:55;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:3:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:129;s:1:\"g\";i:129;s:1:\"b\";i:129;s:1:\"a\";d:0.2;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}}}i:2;a:4:{s:2:\"id\";s:13:\"header-bottom\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:8:\"column11\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:2:{i:0;a:3:{s:2:\"id\";s:20:\"n75lp1zoots235dih121\";s:4:\"type\";s:10:\"categories\";s:6:\"params\";a:8:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:105:\"%d9%85%d9%86%d9%88%db%8c-%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c-%d8%b9%d9%85%d9%88%d8%af%db%8c\";s:4:\"type\";s:6:\"select\";}s:15:\"more_cat_button\";a:3:{s:2:\"id\";s:15:\"more_cat_button\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:21:\"more_cat_button_count\";a:3:{s:2:\"id\";s:21:\"more_cat_button_count\";s:5:\"value\";i:6;s:4:\"type\";s:6:\"slider\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:1:{s:16:\"background-color\";a:4:{s:1:\"r\";i:255;s:1:\"g\";i:255;s:1:\"b\";i:255;s:1:\"a\";i:1;}}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}}}i:1;a:3:{s:2:\"id\";s:20:\"ah9p0q61rqrvvibdgzml\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:2:{s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}}}i:1;a:3:{s:2:\"id\";s:8:\"column12\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"tiueim5f5uazw1f1dm8r\";s:4:\"type\";s:8:\"mainmenu\";s:6:\"params\";a:5:{s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:5:\"right\";s:4:\"type\";s:8:\"selector\";}s:11:\"full_screen\";a:3:{s:2:\"id\";s:11:\"full_screen\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column13\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"x8vdfqly4j60o5jkmb5e\";s:4:\"type\";s:6:\"button\";s:6:\"params\";a:26:{s:5:\"title\";a:3:{s:2:\"id\";s:5:\"title\";s:5:\"value\";s:26:\"% تخفیف های روز\";s:4:\"type\";s:4:\"text\";}s:4:\"link\";a:3:{s:2:\"id\";s:4:\"link\";s:5:\"value\";a:1:{s:3:\"url\";s:46:\"https://demo.iran-woodmart.ir/zomorod/on-sale/\";}s:4:\"type\";s:4:\"link\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:7:\"primary\";s:4:\"type\";s:8:\"selector\";}s:4:\"size\";a:3:{s:2:\"id\";s:4:\"size\";s:5:\"value\";s:5:\"large\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:5:\"shape\";a:3:{s:2:\"id\";s:5:\"shape\";s:5:\"value\";s:9:\"rectangle\";s:4:\"type\";s:8:\"selector\";}s:12:\"icon_library\";a:3:{s:2:\"id\";s:12:\"icon_library\";s:5:\"value\";s:11:\"fontawesome\";s:4:\"type\";s:6:\"select\";}s:16:\"icon_fontawesome\";a:3:{s:2:\"id\";s:16:\"icon_fontawesome\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:15:\"icon_openiconic\";a:3:{s:2:\"id\";s:15:\"icon_openiconic\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_typicons\";a:3:{s:2:\"id\";s:13:\"icon_typicons\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:11:\"icon_entypo\";a:3:{s:2:\"id\";s:11:\"icon_entypo\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_linecons\";a:3:{s:2:\"id\";s:13:\"icon_linecons\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:15:\"icon_monosocial\";a:3:{s:2:\"id\";s:15:\"icon_monosocial\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_material\";a:3:{s:2:\"id\";s:13:\"icon_material\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:13:\"icon_position\";a:3:{s:2:\"id\";s:13:\"icon_position\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"button_inline\";a:3:{s:2:\"id\";s:13:\"button_inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"align\";a:3:{s:2:\"id\";s:5:\"align\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:14:\"bg_color_hover\";a:3:{s:2:\"id\";s:14:\"bg_color_hover\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:18:\"color_scheme_hover\";a:3:{s:2:\"id\";s:18:\"color_scheme_hover\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:20:\"button_smooth_scroll\";a:3:{s:2:\"id\";s:20:\"button_smooth_scroll\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:8:\"switcher\";}s:25:\"button_smooth_scroll_time\";a:3:{s:2:\"id\";s:25:\"button_smooth_scroll_time\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:27:\"button_smooth_scroll_offset\";a:3:{s:2:\"id\";s:27:\"button_smooth_scroll_offset\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:8:\"el_class\";a:3:{s:2:\"id\";s:8:\"el_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:11:{s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";a:3:{s:5:\"width\";s:1:\"1\";s:5:\"color\";a:4:{s:1:\"r\";i:222;s:1:\"g\";i:222;s:1:\"b\";i:222;s:1:\"a\";i:1;}s:5:\"sides\";a:1:{i:0;s:6:\"bottom\";}}s:4:\"type\";s:6:\"border\";}}}}}s:8:\"settings\";a:9:{s:7:\"overlap\";a:3:{s:2:\"id\";s:7:\"overlap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"boxed\";a:3:{s:2:\"id\";s:5:\"boxed\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"dropdowns_dark\";a:3:{s:2:\"id\";s:14:\"dropdowns_dark\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_shadow\";a:3:{s:2:\"id\";s:13:\"sticky_shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"hide_on_scroll\";a:3:{s:2:\"id\";s:14:\"hide_on_scroll\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_effect\";a:3:{s:2:\"id\";s:13:\"sticky_effect\";s:5:\"value\";s:5:\"slide\";s:4:\"type\";s:8:\"selector\";}s:12:\"sticky_clone\";a:3:{s:2:\"id\";s:12:\"sticky_clone\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}}s:4:\"name\";s:21:\"Default header layout\";s:2:\"id\";s:14:\"default_header\";}", "yes");
INSERT INTO `wp_options` VALUES("376", "whb_saved_headers", "a:2:{s:14:\"default_header\";a:2:{s:2:\"id\";s:14:\"default_header\";s:4:\"name\";s:21:\"Default header layout\";}s:13:\"header_246188\";a:2:{s:2:\"id\";s:13:\"header_246188\";s:4:\"name\";s:19:\"سربرگ اصلی\";}}", "yes");
INSERT INTO `wp_options` VALUES("381", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("611", "woodmart_pa_brand_swatch_size", "default", "yes");
INSERT INTO `wp_options` VALUES("612", "woodmart_pa_brand_show_on_product", "", "yes");
INSERT INTO `wp_options` VALUES("819", "widget_mc4wp_form_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("820", "mc4wp_version", "4.10.4", "yes");
INSERT INTO `wp_options` VALUES("821", "mc4wp_flash_messages", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("824", "mc4wp", "a:6:{s:19:\"grecaptcha_site_key\";s:0:\"\";s:21:\"grecaptcha_secret_key\";s:0:\"\";s:7:\"api_key\";s:0:\"\";s:20:\"allow_usage_tracking\";i:0;s:15:\"debug_log_level\";s:7:\"warning\";s:18:\"first_activated_on\";i:1580151499;}", "yes");
INSERT INTO `wp_options` VALUES("825", "mc4wp_default_form_id", "68", "yes");
INSERT INTO `wp_options` VALUES("827", "mc4wp_form_stylesheets", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("1124", "revslider_update_revision_current", "6.7.24", "yes");
INSERT INTO `wp_options` VALUES("1213", "woodmart-vc-imported-media", "a:1:{i:146;s:90:\"http://dummy.xtemos.com/woodmart/demos/wp-content/uploads/sites/2/2018/09/cars-video-4.jpg\";}", "yes");
INSERT INTO `wp_options` VALUES("1271", "woocommerce_default_catalog_orderby", "date", "yes");
INSERT INTO `wp_options` VALUES("1272", "woocommerce_maybe_regenerate_images_hash", "28dc1b60493fb1f45b4d923c242c6423", "yes");
INSERT INTO `wp_options` VALUES("1388", "woodmart_import_attributes", "1", "yes");
INSERT INTO `wp_options` VALUES("1400", "wpcf7", "a:2:{s:7:\"version\";s:3:\"5.6\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1580216503;s:7:\"version\";s:5:\"5.1.6\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("1442", "woodmart_pa_color_swatch_size", "default", "yes");
INSERT INTO `wp_options` VALUES("1443", "woodmart_pa_color_show_on_product", "", "yes");
INSERT INTO `wp_options` VALUES("1600", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2022", "woodmart_purchase_code", "********************************", "yes");
INSERT INTO `wp_options` VALUES("2027", "woodmart-update-time", "1749706315", "yes");
INSERT INTO `wp_options` VALUES("2028", "woodmart-update-info", "O:8:\"stdClass\":6:{s:11:\"new_version\";s:5:\"8.2.2\";s:7:\"version\";s:5:\"8.2.2\";s:5:\"theme\";s:8:\"woodmart\";s:7:\"checked\";i:1749706315;s:3:\"url\";s:41:\"https://xtemos.com/woodmart-changelog.php\";s:7:\"package\";s:65:\"https://xtemos.com/wp-json/xts/v1/download?token=1&theme=woodmart\";}", "yes");
INSERT INTO `wp_options` VALUES("2063", "rs_image_meta_todo", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("2174", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("2186", "action_scheduler_hybrid_store_demarkation", "267", "yes");
INSERT INTO `wp_options` VALUES("2187", "schema-ActionScheduler_StoreSchema", "7.0.1729623524", "yes");
INSERT INTO `wp_options` VALUES("2188", "schema-ActionScheduler_LoggerSchema", "3.0.1657351444", "yes");
INSERT INTO `wp_options` VALUES("2189", "woocommerce_onboarding_opt_in", "no", "yes");
INSERT INTO `wp_options` VALUES("2192", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("2194", "woocommerce_onboarding_profile", "a:1:{s:9:\"completed\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("2199", "woocommerce_admin_install_timestamp", "1587485430", "yes");
INSERT INTO `wp_options` VALUES("2204", "action_scheduler_lock_async-request-runner", "684ab0e2651e44.08179037|1749725470", "yes");
INSERT INTO `wp_options` VALUES("2210", "woocommerce_admin_last_orders_milestone", "1", "yes");
INSERT INTO `wp_options` VALUES("2217", "recovery_mode_email_last_sent", "1630759117", "yes");
INSERT INTO `wp_options` VALUES("2240", "xts-default_header-site-url", "105934ba3e148e8bb5909100634c7e87", "yes");
INSERT INTO `wp_options` VALUES("2241", "xts-theme_settings_default-site-url", "74be47fbb32e3be9a8991449a3f7471d", "on");
INSERT INTO `wp_options` VALUES("2421", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-b.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-b.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("2422", "rs-templates-counter", "0", "off");
INSERT INTO `wp_options` VALUES("2466", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:21:\"info@iran-woodmart.ir\";s:7:\"version\";s:5:\"6.7.2\";s:9:\"timestamp\";i:1739332745;}", "off");
INSERT INTO `wp_options` VALUES("2481", "widget_wd-widget-stock-status", "a:2:{i:2;a:3:{s:5:\"title\";s:35:\"فیلتر موجودی و حراج\";s:7:\"instock\";s:1:\"1\";s:6:\"onsale\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("2484", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_options` VALUES("2499", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("2582", "elementor_version", "3.29.2", "yes");
INSERT INTO `wp_options` VALUES("2584", "_elementor_installed_time", "1594736256", "yes");
INSERT INTO `wp_options` VALUES("2585", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:20:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:20:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:20:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:20:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:20:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:20:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:20:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:20:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:20:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:20:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:20:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:20:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:20:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:20:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:20:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:20:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:20:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:20:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:20:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:20:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:20:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:20:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:20:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:20:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:20:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:20:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:20:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:20:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:20:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:20:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:20:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:20:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:20:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:20:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:20:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:20:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:20:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:20:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:20:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:20:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:20:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:20:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:20:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:20:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:20:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:20:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:20:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:20:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:20:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:20:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:20:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:20:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:20:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:20:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:20:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:20:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:20:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:20:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:20:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:20:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:20:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:20:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:20:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:20:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:20:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:20:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:20:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:20:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:20:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:20:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:20:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:20:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:20:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:20:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:20:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:20:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:20:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:20:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:20:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:20:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:20:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:20:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:20:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:20:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:20:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:20:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:20:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:20:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:20:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:20:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:20:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:20:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:20:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:20:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:20:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:20:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:20:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:20:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:20:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:20:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:20:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:20:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:20:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:20:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:20:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:20:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:20:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:20:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:20:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:20:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:20:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:20:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:20:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:20:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:20:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:20:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:20:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:20:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:20:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:20:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:20:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:20:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:20:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:20:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:20:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:20:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:20:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:20:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:20:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:20:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:20:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:20:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:20:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:20:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:20:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:20:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:20:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:20:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:20:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:20:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:20:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:20:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:20:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:20:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:20:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:20:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:20:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:20:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:20:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:20:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:20:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:20:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:20:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:20:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:20:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:20:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:20:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:20:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:20:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:20:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:20:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:20:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:20:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:20:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:20:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:20:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:20:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:20:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:20:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:20:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:20:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:20:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:20:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:20:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:20:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:20:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:20:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:20:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:20:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:20:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:20:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:20:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:20:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:20:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:20:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:20:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:20:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:20:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:20:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:20:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:20:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:20:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:20:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:20:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:20:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:20:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:20:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:20:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:20:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:20:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:20:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:20:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:20:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:20:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:20:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:20:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:20:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:20:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:20:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:20:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:20:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:20:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:20:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:20:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:20:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:20:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:20:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:20:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:20:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:20:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:20:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:20:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:20:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:20:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:20:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:20:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:20:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:20:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:20:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:20:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:20:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:20:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:20:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:20:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:20:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:20:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:20:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:20:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:20:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:20:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:20:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:20:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:20:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:20:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:20:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:20:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:20:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:20:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:20:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:20:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:20:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:255;a:20:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:20:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:20:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:258;a:20:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:20:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:20:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:20:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:20:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:20:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:20:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:20:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:20:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:20:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:20:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:20:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:20:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:20:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:20:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:20:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:20:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:20:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:20:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:277;a:20:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:20:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:20:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:20:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:281;a:20:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:20:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:20:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:20:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:20:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:20:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:287;a:20:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:288;a:20:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:289;a:20:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:20:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:20:{s:4:\"tmpl\";i:1412;s:2:\"id\";i:24033;s:5:\"title\";s:37:\"Dance Studio &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg\";s:12:\"tmpl_created\";i:1649881344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:113:\"[\"Academy\",\"Business\",\"Dance Studio\",\"Form\",\"Pilates\",\"School\",\"Sport\",\"Teacher\",\"Training\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:20:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:20:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:20:{s:4:\"tmpl\";i:1413;s:2:\"id\";i:24049;s:5:\"title\";s:33:\"ECO Shop &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg\";s:12:\"tmpl_created\";i:1649882053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:110:\"[\"Aesthetic\",\"Business\",\"Creative\",\"Decor\",\"Health\",\"Help\",\"Lifestyle\",\"Products\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:20:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:296;a:20:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:20:{s:4:\"tmpl\";i:1419;s:2:\"id\";i:24136;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg\";s:12:\"tmpl_created\";i:1650990034;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:62:\"[\"Blog\",\"Business\",\"Coming Soon\",\"Cooking\",\"Education\",\"Food\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:298;a:20:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:20:{s:4:\"tmpl\";i:1411;s:2:\"id\";i:24020;s:5:\"title\";s:35:\"Mobile App &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg\";s:12:\"tmpl_created\";i:1649880955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"App\",\"Business\",\"Coding\",\"Computer\",\"Launch\",\"Mobile\",\"Under Construction\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:20:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:301;a:20:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:302;a:20:{s:4:\"tmpl\";i:1420;s:2:\"id\";i:24152;s:5:\"title\";s:32:\"Perfume Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg\";s:12:\"tmpl_created\";i:1650990353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Business\",\"Coming Soon\",\"Cosmetics\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:20:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:20:{s:4:\"tmpl\";i:1418;s:2:\"id\";i:24126;s:5:\"title\";s:28:\"Skincare &#8211; Coming Soon\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg\";s:12:\"tmpl_created\";i:1650989585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:128:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Coming Soon\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Services\",\"Skincare\",\"Treatment\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:20:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:20:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:307;a:20:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:308;a:20:{s:4:\"tmpl\";i:1410;s:2:\"id\";i:24004;s:5:\"title\";s:33:\"Skincare &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg\";s:12:\"tmpl_created\";i:1649880534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:144:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Makeup\",\"Services\",\"Skincare\",\"Treatment\",\"Under Construction\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:20:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"Moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:20:{s:4:\"tmpl\";i:1415;s:2:\"id\";i:24092;s:5:\"title\";s:29:\"Vase Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg\";s:12:\"tmpl_created\";i:1650988613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:20:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:20:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:20:{s:4:\"tmpl\";i:1248;s:2:\"id\";i:22134;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647176713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:20:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:315;a:20:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:20:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:20:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:20:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:20:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:320;a:20:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"Stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:20:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:20:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:45:\"Aesthetic Clinic &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:20:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"Medical\",\"Online\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:20:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:325;a:20:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:20:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:327;a:20:{s:4:\"tmpl\";i:1250;s:2:\"id\";i:22140;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1647177317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:20:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:329;a:20:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:20:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:20:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:20:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:333;a:20:{s:4:\"tmpl\";i:1179;s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:20:{s:4:\"tmpl\";i:506;s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/ab